/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.web.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.ModuleDeploymentDescriptor;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.List;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleHandler.class}, property={"service.vendor=IBM", "type:String=web"})
public class WebModuleHandlerImpl
implements ModuleHandler {
    private FutureMonitor futureMonitor;
    private MetaDataService metaDataService;
    private StateChangeService stateChangeService;
    private ModuleRuntimeContainer webContainer;
    static final long serialVersionUID = -1413207851514053832L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setFutureMonitor(FutureMonitor fm) {
        this.futureMonitor = fm;
    }

    @Reference
    protected void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    @Reference
    protected void setStateChangeService(StateChangeService stateChangeService) {
        this.stateChangeService = stateChangeService;
    }

    @Reference(target="(type=web)")
    protected void setWebContainer(ModuleRuntimeContainer webContainer) {
        this.webContainer = webContainer;
    }

    public ModuleMetaData createModuleMetaData(ModuleInfo webModuleInfo, DeployedAppInfoBase deployedApp) throws MetaDataException {
        return this.webContainer.createModuleMetaData(webModuleInfo);
    }

    /*
     * WARNING - void declaration
     */
    public Future<Boolean> deployModule(ModuleInfo webModuleInfo, DeployedAppInfoBase deployedApp) {
        Future started;
        StateChangeService stateChange = this.stateChangeService;
        DeployedModuleInfoImpl deployedMod = deployedApp.getDeployedModule(webModuleInfo);
        ModuleMetaData mmd = ((ExtendedModuleInfo)webModuleInfo).getMetaData();
        if (mmd == null) {
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult((Object)false);
        }
        try {
            this.metaDataService.fireModuleMetaDataCreated(mmd, webModuleInfo.getContainer());
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"88", (Object)this, (Object[])new Object[]{webModuleInfo, deployedApp});
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)ex);
        }
        deployedMod.starting = true;
        try {
            stateChange.fireModuleStarting(webModuleInfo);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"96", (Object)this, (Object[])new Object[]{webModuleInfo, deployedApp});
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, ex);
        }
        try {
            started = this.webContainer.startModule(webModuleInfo);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"104", (Object)this, (Object[])new Object[]{webModuleInfo, deployedApp});
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)ex);
        }
        deployedMod.started = true;
        try {
            stateChange.fireModuleStarted(webModuleInfo);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"112", (Object)this, (Object[])new Object[]{webModuleInfo, deployedApp});
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, ex);
        }
        return started;
    }

    /*
     * WARNING - void declaration
     */
    public ModuleInfo deployModule(ApplicationInfo appInfo, String contextRoot, Container moduleContainer, ClassLoader loader, String moduleLocation) throws StateChangeException, UnableToAdaptException, MetaDataException {
        ClassLoader moduleClassLoader;
        ModuleClassLoaderFactory classLoaderFactory;
        String moduleURI = ModuleInfoUtils.getModuleURIFromLocation((String)moduleLocation);
        String moduleName = ModuleInfoUtils.getModuleName((ModuleDeploymentDescriptor)((ModuleDeploymentDescriptor)moduleContainer.adapt(WebApp.class)), (String)moduleURI);
        WebModuleInfoImpl webModule = new WebModuleInfoImpl(appInfo, moduleName, moduleURI, contextRoot, moduleContainer, null, null, classLoaderFactory = new ModuleClassLoaderFactory(moduleClassLoader = loader){
            final /* synthetic */ ClassLoader val$moduleClassLoader;
            static final long serialVersionUID = 5472419009492985105L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.val$moduleClassLoader = classLoader;
            }

            public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
                return this.val$moduleClassLoader;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        ModuleMetaData moduleMetaData = this.webContainer.createModuleMetaData((ModuleInfo)webModule);
        if (moduleMetaData == null) {
            return null;
        }
        webModule.setMetaData(moduleMetaData);
        MetaDataService metaData = this.metaDataService;
        StateChangeService stateChange = this.stateChangeService;
        if (metaData != null) {
            try {
                metaData.fireModuleMetaDataCreated(moduleMetaData, webModule.getContainer());
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"152", (Object)this, (Object[])new Object[]{appInfo, contextRoot, moduleContainer, loader, moduleLocation});
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireModuleMetaDataCreated");
                return null;
            }
        }
        if (stateChange != null) {
            try {
                stateChange.fireModuleStarting((ModuleInfo)webModule);
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"160", (Object)this, (Object[])new Object[]{appInfo, contextRoot, moduleContainer, loader, moduleLocation});
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireModuleStarting");
                return null;
            }
        }
        this.webContainer.startModule((ModuleInfo)webModule);
        if (stateChange != null) {
            try {
                stateChange.fireModuleStarted((ModuleInfo)webModule);
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"171", (Object)this, (Object[])new Object[]{appInfo, contextRoot, moduleContainer, loader, moduleLocation});
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireModuleStarted");
                return null;
            }
        }
        return webModule;
    }

    /*
     * WARNING - void declaration
     */
    public void undeployModule(ModuleInfo moduleInfo) {
        try {
            this.stateChangeService.fireModuleStopping(moduleInfo);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"184", (Object)this, (Object[])new Object[]{moduleInfo});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireModuleStopping");
        }
        try {
            this.webContainer.stopModule(moduleInfo);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"190", (Object)this, (Object[])new Object[]{moduleInfo});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"stopModule");
        }
        try {
            this.stateChangeService.fireModuleStopped(moduleInfo);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"196", (Object)this, (Object[])new Object[]{moduleInfo});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireModuleStopped");
        }
        try {
            this.metaDataService.fireModuleMetaDataDestroyed(((ExtendedModuleInfo)moduleInfo).getMetaData());
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"202", (Object)this, (Object[])new Object[]{moduleInfo});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"fireModuleMetaDataDestroyed");
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean undeployModule(DeployedModuleInfoImpl deployedModule) {
        boolean success = true;
        if (deployedModule.started) {
            try {
                this.stateChangeService.fireModuleStopping(deployedModule.info);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"213", (Object)this, (Object[])new Object[]{deployedModule});
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStopping");
                success = false;
            }
            try {
                this.webContainer.stopModule(deployedModule.info);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"220", (Object)this, (Object[])new Object[]{deployedModule});
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"stopModule");
                success = false;
            }
        }
        if (deployedModule.starting) {
            try {
                this.stateChangeService.fireModuleStopped(deployedModule.info);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"228", (Object)this, (Object[])new Object[]{deployedModule});
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStopped");
                success = false;
            }
        }
        try {
            this.metaDataService.fireModuleMetaDataDestroyed(((ExtendedModuleInfo)deployedModule.info).getMetaData());
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.web.internal.WebModuleHandlerImpl", (String)"235", (Object)this, (Object[])new Object[]{deployedModule});
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleMetaDataDestroyed");
            success = false;
        }
        return success;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebModuleHandlerImpl.class);
    }
}

