/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ear.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.adaptable.module.structure.StructureHelper;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo;
import com.ibm.ws.app.manager.ear.internal.EARStructureHelper;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppMBeanRuntime;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.war.internal.ZipUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.InterpretedContainer;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type:String=ear"})
public class EARDeployedAppInfoFactoryImpl
extends DeployedAppInfoFactoryBase {
    private static final TraceComponent _tc = Tr.register(EARDeployedAppInfoFactoryImpl.class);
    private static final Map<String, Long> timestamps = new HashMap<String, Long>();
    protected ModuleHandler webModuleHandler;
    protected ModuleHandler ejbModuleHandler;
    protected ModuleHandler clientModuleHandler;
    protected ModuleHandler connectorModuleHandler;
    protected DeployedAppMBeanRuntime appMBeanRuntime;
    private ServiceReference<JavaEEVersion> versionRef;
    protected volatile Version platformVersion = JavaEEVersion.DEFAULT_VERSION;
    private ApplicationManager applicationManager;
    private final ZipUtils zipUtils = new ZipUtils();
    static final long serialVersionUID = 6889301581516323226L;

    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setVersion(ServiceReference<JavaEEVersion> reference) {
        this.versionRef = reference;
        this.platformVersion = Version.parseVersion((String)((String)reference.getProperty("version")));
    }

    protected synchronized void unsetVersion(ServiceReference<JavaEEVersion> reference) {
        if (reference == this.versionRef) {
            this.versionRef = null;
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    @Reference(target="(type=web)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWebModuleHandler(ModuleHandler handler) {
        this.webModuleHandler = handler;
    }

    protected void unsetWebModuleHandler(ModuleHandler handler) {
        this.webModuleHandler = null;
    }

    @Reference(target="(type=ejb)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEjbModuleHandler(ModuleHandler handler) {
        this.ejbModuleHandler = handler;
    }

    protected void unsetEjbModuleHandler(ModuleHandler handler) {
        this.ejbModuleHandler = null;
    }

    @Reference(target="(type=client)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setClientModuleHandler(ModuleHandler handler) {
        this.clientModuleHandler = handler;
    }

    protected void unsetClientModuleHandler(ModuleHandler handler) {
        this.clientModuleHandler = null;
    }

    @Reference(target="(type=connector)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setConnectorModuleHandler(ModuleHandler handler) {
        this.connectorModuleHandler = handler;
    }

    protected void unsetConnectorModuleHandler(ModuleHandler handler) {
        this.connectorModuleHandler = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setDeployedAppMBeanRuntime(DeployedAppMBeanRuntime appMBeanRuntime) {
        this.appMBeanRuntime = appMBeanRuntime;
    }

    protected void unsetDeployedAppMBeanRuntime(DeployedAppMBeanRuntime appMBeanRuntime) {
        this.appMBeanRuntime = null;
    }

    @Reference
    protected void setApplicationManager(ApplicationManager mgr) {
        this.applicationManager = mgr;
    }

    protected void unsetApplicationManager(ApplicationManager mgr) {
        this.applicationManager = null;
    }

    /*
     * WARNING - void declaration
     */
    public DeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> applicationInformation) throws UnableToAdaptException {
        Application applicationDD;
        Container applicationContainer = applicationInformation.getContainer();
        try {
            String location;
            File earFile;
            if (this.applicationManager.getExpandApps() && (earFile = new File(location = applicationInformation.getLocation())).isFile() && !location.toLowerCase().endsWith(".xml")) {
                WsResource expandedAppsDir = this.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/");
                expandedAppsDir.create();
                Long earFileTimestamp = timestamps.put(earFile.getAbsolutePath(), earFile.lastModified());
                WsResource expandedEarDir = this.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/" + applicationInformation.getName() + ".ear/");
                if (expandedEarDir.exists()) {
                    if (earFileTimestamp == null || earFileTimestamp.longValue() != earFile.lastModified()) {
                        this.zipUtils.recursiveDelete(expandedEarDir.asFile());
                        expandedEarDir.create();
                        this.zipUtils.unzip(earFile, expandedEarDir.asFile());
                    }
                } else {
                    expandedEarDir.create();
                    this.zipUtils.unzip(earFile, expandedEarDir.asFile());
                }
                applicationContainer = this.setupContainer(applicationInformation.getPid(), expandedEarDir.asFile());
            }
        }
        catch (IOException location) {
            void ex;
            FFDCFilter.processException((Throwable)location, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl", (String)"190", (Object)((Object)this), (Object[])new Object[]{applicationInformation});
            Tr.error((TraceComponent)_tc, (String)"warning.could.not.expand.application", (Object[])new Object[]{applicationInformation.getName(), ex.getMessage()});
        }
        try {
            applicationDD = (Application)applicationContainer.adapt(Application.class);
        }
        catch (UnableToAdaptException earFile) {
            void e;
            FFDCFilter.processException((Throwable)earFile, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl", (String)"200", (Object)((Object)this), (Object[])new Object[]{applicationInformation});
            Tr.error((TraceComponent)_tc, (String)"error.application.parse.descriptor", (Object[])new Object[]{applicationInformation.getName(), "META-INF/application.xml", e});
            throw e;
        }
        InterpretedContainer jeeContainer = applicationContainer instanceof InterpretedContainer ? (InterpretedContainer)applicationContainer : (InterpretedContainer)applicationContainer.adapt(InterpretedContainer.class);
        if (applicationDD == null) {
            jeeContainer.setStructureHelper(EARStructureHelper.getUnknownRootInstance());
        } else {
            ArrayList<String> modulePaths = new ArrayList<String>();
            for (Module module : applicationDD.getModules()) {
                modulePaths.add(module.getModulePath());
            }
            jeeContainer.setStructureHelper((StructureHelper)EARStructureHelper.create(modulePaths));
        }
        applicationInformation.setContainer((Container)jeeContainer);
        EARDeployedAppInfo deployedApp = new EARDeployedAppInfo(applicationInformation, applicationDD, this);
        applicationInformation.setHandlerInfo((Object)deployedApp);
        return deployedApp;
    }
}

