/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.ExtractableArtifactEntry;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileNestedDirContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.NavigableMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileEntry
implements ExtractableArtifactEntry {
    static final TraceComponent tc = Tr.register(ZipFileEntry.class);
    private ArtifactContainer enclosingContainer;
    private final ZipEntry zipEntry;
    private final ZipFileContainer rootContainer;
    private final NavigableMap<String, ZipEntry> allEntries;
    private final String name;
    private final String path;
    private final File archiveFile;
    private final ContainerFactoryHolder containerFactoryHolder;
    static final long serialVersionUID = 3109383957899493457L;

    @Trivial
    @ManualTrace
    ZipFileEntry(ZipFileContainer zc, ZipEntry f, String name, String path, File af, NavigableMap<String, ZipEntry> allEntries, ContainerFactoryHolder cfh) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{zc, f, name, path, af, allEntries == null ? null : Integer.valueOf(allEntries.size()), cfh});
        }
        this.zipEntry = f;
        this.rootContainer = zc;
        this.archiveFile = af;
        this.allEntries = allEntries;
        this.name = name;
        this.path = path;
        this.containerFactoryHolder = cfh;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public ArtifactContainer getEnclosingContainer() {
        if (this.enclosingContainer == null) {
            String parent = PathUtils.getParent((String)this.path);
            if (parent == null || "".equals(parent) || "/".equals(parent)) {
                this.enclosingContainer = this.rootContainer;
            } else {
                ArtifactEntry parentEntry = this.rootContainer.getEntry(parent, true);
                this.enclosingContainer = parentEntry.convertToContainer();
            }
        }
        return this.enclosingContainer;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public ArtifactContainer convertToContainer() {
        return this.convertToContainer(false);
    }

    public ArtifactContainer convertToContainer(boolean localOnly) {
        ZipFileNestedDirContainer rv = null;
        if (this.zipEntry != null && this.zipEntry.isDirectory()) {
            rv = new ZipFileNestedDirContainer(this.rootContainer, this.getEnclosingContainer(), this.archiveFile, (ArtifactEntry)this, this.allEntries, this.name, this.containerFactoryHolder);
        }
        if (this.zipEntry != null && !this.zipEntry.isDirectory() && rv == null && !localOnly) {
            File newCacheDir = this.rootContainer.getNewCacheDirForEntry((ArtifactEntry)this);
            rv = this.containerFactoryHolder.getContainerFactory().getContainer(newCacheDir, this.getEnclosingContainer(), (ArtifactEntry)this, (Object)this.zipEntry);
        }
        if (this.zipEntry == null && rv == null) {
            rv = new ZipFileNestedDirContainer(this.rootContainer, this.getEnclosingContainer(), this.archiveFile, (ArtifactEntry)this, this.allEntries, this.name, this.containerFactoryHolder);
        }
        return rv;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStream() throws IOException {
        InputStream baseInputStream;
        if (this.zipEntry == null || this.zipEntry.isDirectory()) {
            return null;
        }
        final ZipFileHandle zfh = this.rootContainer.getZipFileHandle();
        ZipFile zf = zfh.open();
        try {
            baseInputStream = zfh.getInputStream(zf, this.zipEntry);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileEntry", (String)"175", (Object)this, (Object[])new Object[0]);
            zfh.close();
            throw e;
        }
        FilterInputStream wrappedInputStream = new FilterInputStream(baseInputStream){
            boolean isClosed;
            static final long serialVersionUID = 1660468942746005464L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                super(x0);
                this.isClosed = false;
            }

            @Override
            public synchronized void close() throws IOException {
                if (!this.isClosed) {
                    try {
                        super.close();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileEntry$1", (String)"197", (Object)this, (Object[])new Object[0]);
                    }
                    zfh.close();
                    this.isClosed = true;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        return wrappedInputStream;
    }

    public long getSize() {
        if (this.zipEntry != null) {
            return this.zipEntry.getSize();
        }
        return 0L;
    }

    public ArtifactContainer getRoot() {
        return this.rootContainer;
    }

    public long getLastModified() {
        if (this.zipEntry != null) {
            return this.zipEntry.getTime();
        }
        return 0L;
    }

    public URL getResource() {
        URI entryUri;
        String path = this.getPath();
        if (this.zipEntry == null || this.zipEntry.isDirectory()) {
            path = path + "/";
        }
        if ((entryUri = this.rootContainer.createEntryUri(path, this.archiveFile)) != null) {
            try {
                return entryUri.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileEntry", (String)"258", (Object)this, (Object[])new Object[0]);
                return null;
            }
        }
        return null;
    }

    public String getPhysicalPath() {
        return null;
    }

    public File extract() throws IOException {
        return this.rootContainer.extractEntryToCacheFile((ArtifactEntry)this);
    }
}

