/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.contributor.ArtifactContainerFactoryHelper;
import com.ibm.ws.artifact.zip.cache.ZipCachingService;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.Utils;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileContainerFactory
implements ArtifactContainerFactoryHelper,
ContainerFactoryHolder {
    static final TraceComponent tc = Tr.register(ZipFileContainerFactory.class);
    private ArtifactContainerFactory containerFactory = null;
    private ZipCachingService zipCachingService = null;
    private BundleContext ctx = null;
    private GlobalClassloadingConfiguration classLoadingConfiguration;
    static final long serialVersionUID = -1724155493620242578L;

    private boolean hasZipExtension(String name) {
        return name.matches("(?i:(.*)\\.(ZIP|[SEJRW]AR|E[BS]A))");
    }

    public ArtifactContainer createContainer(File cacheDir, Object o) {
        File f;
        ZipFileContainer zfc = null;
        if (o instanceof File && Utils.isFile((File)o) && this.isZip(f = (File)o)) {
            zfc = new ZipFileContainer(cacheDir, f, this);
        }
        return zfc;
    }

    public ArtifactContainer createContainer(File cacheDir, ArtifactContainer parent, ArtifactEntry e, Object o) {
        ZipFileContainer zfc = null;
        if (o instanceof File && Utils.isFile((File)o)) {
            File f = (File)o;
            if (this.isZip(f)) {
                zfc = new ZipFileContainer(cacheDir, parent, e, f, this);
            }
        } else if (this.isZip(e)) {
            zfc = new ZipFileContainer(cacheDir, parent, e, null, this);
        }
        return zfc;
    }

    private boolean isZip(ArtifactEntry e) {
        boolean validZip = false;
        if (this.hasZipExtension(e.getName())) {
            InputStream is = null;
            try {
                is = e.getInputStream();
                if (is == null) {
                    return false;
                }
                if (!(is instanceof BufferedInputStream)) {
                    is = new BufferedInputStream(is);
                }
                ZipInputStream zis = new ZipInputStream(is);
                try {
                    zis.getNextEntry();
                    validZip = true;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory", (String)"103", (Object)this, (Object[])new Object[]{e});
                    String path = e.getPath();
                    if (e.getPhysicalPath() != null) {
                        path = e.getPhysicalPath();
                    } else if (e.getRoot().getPhysicalPath() != null) {
                        path = e.getRoot().getPhysicalPath() + "!" + path;
                    } else {
                        boolean found = false;
                        ArtifactEntry parent = e.getRoot().getEntryInEnclosingContainer();
                        while (parent != null) {
                            path = parent.getPhysicalPath() != null ? parent.getPhysicalPath() + "!" + path : parent.getPath() + "!" + path;
                            parent = parent.getRoot().getEntryInEnclosingContainer();
                        }
                    }
                    Tr.error((TraceComponent)tc, (String)"bad.zip.data", (Object[])new Object[]{path});
                }
                try {
                    zis.close();
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory", (String)"145", (Object)this, (Object[])new Object[]{e});
                }
            }
            catch (IOException zis) {
                FFDCFilter.processException((Throwable)zis, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory", (String)"148", (Object)this, (Object[])new Object[]{e});
                return false;
            }
        }
        return validZip;
    }

    @FFDCIgnore(value={IOException.class})
    private boolean isZip(File f) {
        boolean validZip = false;
        if (this.hasZipExtension(f.getName())) {
            try {
                ZipFile zf = Utils.newZipFile(f);
                validZip = true;
                zf.close();
            }
            catch (IOException e) {
                Tr.error((TraceComponent)tc, (String)"bad.zip.data", (Object[])new Object[]{f.getAbsolutePath()});
            }
        }
        return validZip;
    }

    protected synchronized void activate(ComponentContext ctx) {
        this.ctx = ctx.getBundleContext();
    }

    protected synchronized void deactivate(ComponentContext ctx) {
        this.containerFactory = null;
        this.ctx = null;
    }

    protected synchronized void setContainerFactory(ArtifactContainerFactory cf) {
        this.containerFactory = cf;
    }

    protected synchronized void unsetContainerFactory(ArtifactContainerFactory cf) {
        if (this.containerFactory == cf) {
            this.containerFactory = null;
        }
    }

    protected void setGlobalClassloadingConfiguration(GlobalClassloadingConfiguration globalClassloadingConfiguration) {
        this.classLoadingConfiguration = globalClassloadingConfiguration;
    }

    protected void setZipCachingService(ZipCachingService zcs) {
        this.zipCachingService = zcs;
    }

    @Override
    public synchronized ArtifactContainerFactory getContainerFactory() {
        if (this.containerFactory == null) {
            throw new IllegalStateException();
        }
        return this.containerFactory;
    }

    @Override
    public synchronized BundleContext getBundleContext() {
        if (this.ctx == null) {
            throw new IllegalStateException();
        }
        return this.ctx;
    }

    @Override
    public ZipCachingService getZipCachingService() {
        if (this.zipCachingService == null) {
            throw new IllegalStateException();
        }
        return this.zipCachingService;
    }

    @Override
    public boolean useJarUrls() {
        if (this.classLoadingConfiguration != null) {
            return this.classLoadingConfiguration.useJarUrls();
        }
        return false;
    }
}

