/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.subsystem.AriesSubsystem;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleRevisionResource;
import org.apache.aries.subsystem.core.internal.SystemRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SystemRepositoryManager {
    private static final Filter filter = SystemRepositoryManager.createFilter();
    private final BundleTracker<AtomicReference<BundleRevisionResource>> bundleTracker;
    private final ServiceTracker<AriesSubsystem, BasicSubsystem> serviceTracker;
    private final SystemRepository systemRepository;

    private static Filter createFilter() {
        try {
            return FrameworkUtil.createFilter((String)("(&(!(|(" + "subsystem.state" + '=' + Subsystem.State.INSTALL_FAILED + ")(" + "subsystem.state" + '=' + Subsystem.State.UNINSTALLING + ")(" + "subsystem.state" + '=' + Subsystem.State.UNINSTALLED + ")))(" + "objectClass" + '=' + AriesSubsystem.class.getName() + "))"));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public SystemRepositoryManager(BundleContext bundleContext) {
        this.systemRepository = new SystemRepository(bundleContext);
        this.bundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)this.systemRepository);
        this.serviceTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)this.systemRepository);
    }

    public SystemRepository getSystemRepository() {
        return this.systemRepository;
    }

    public void open() {
        this.bundleTracker.open();
        this.serviceTracker.open();
    }

    public void close() {
        this.serviceTracker.close();
        this.bundleTracker.close();
    }
}

