/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import org.apache.aries.subsystem.core.archive.AriesProvisionDependenciesDirective;
import org.apache.aries.subsystem.core.archive.PreferredProviderHeader;
import org.apache.aries.subsystem.core.archive.ProvisionPolicyDirective;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.archive.SubsystemTypeHeader;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class SubsystemManifestValidator {
    public static void validate(BasicSubsystem subsystem, SubsystemManifest manifest) {
        if (subsystem.getResource().getId() == 0L) {
            return;
        }
        SubsystemManifestValidator.validatePreferredProviderHeader(manifest.getPreferredProviderHeader());
        SubsystemManifestValidator.validateAriesProvisionDependenciesDirective(subsystem);
        if (subsystem.isComposite()) {
            SubsystemContentHeader header = manifest.getSubsystemContentHeader();
            if (header == null) {
                return;
            }
            for (SubsystemContentHeader.Clause clause : header.getClauses()) {
                if (clause.getVersionRange().isExact()) continue;
                throw new SubsystemException("Composite subsystem using version range for content: " + clause);
            }
        } else if (subsystem.isFeature()) {
            SubsystemTypeHeader subsystemTypeHeader = manifest.getSubsystemTypeHeader();
            ProvisionPolicyDirective provisionPolicyDirective = subsystemTypeHeader.getProvisionPolicyDirective();
            if (provisionPolicyDirective.isAcceptDependencies()) {
                throw new SubsystemException("Feature subsystems may not declare a provision-policy of acceptDependencies");
            }
            if (manifest.getHeaders().get("Preferred-Provider") != null) {
                throw new SubsystemException("Feature subsystems may not declare a Preferred-Provider header");
            }
        }
    }

    private static void validatePreferredProviderHeader(PreferredProviderHeader header) {
        if (header == null) {
            return;
        }
        for (PreferredProviderHeader.Clause clause : header.getClauses()) {
            String type = (String)clause.getAttribute("type").getValue();
            if ("osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type) || "osgi.bundle".equals(type)) continue;
            throw new SubsystemException("Unsupported Preferred-Provider type: " + type);
        }
    }

    private static void validateAriesProvisionDependenciesDirective(BasicSubsystem subsystem) {
        BasicSubsystem parent;
        AriesProvisionDependenciesDirective parentDirective;
        AriesProvisionDependenciesDirective directive = subsystem.getAriesProvisionDependenciesDirective();
        if (!directive.equals(parentDirective = (parent = subsystem.getResource().getParents().iterator().next()).getAriesProvisionDependenciesDirective()) && (subsystem.isFeature() || Subsystem.State.INSTALLING.equals((Object)parent.getState()))) {
            throw new SubsystemException("The value of the apache-aries-provision-dependencies directive must be the same as the parent subsystem for features and implicitly installed subsystems.");
        }
    }
}

