/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class LockingStrategy {
    private static final int TRY_LOCK_TIME = 30000;
    private static final TimeUnit TRY_LOCK_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition condition = lock.newCondition();
    private static final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private static final ThreadLocal<Map<Subsystem.State, Set<BasicSubsystem>>> local = new ThreadLocal<Map<Subsystem.State, Set<BasicSubsystem>>>(){

        @Override
        protected Map<Subsystem.State, Set<BasicSubsystem>> initialValue() {
            return new HashMap<Subsystem.State, Set<BasicSubsystem>>();
        }
    };

    public static void lock() {
        try {
            if (!lock.tryLock(30000L, TRY_LOCK_TIME_UNIT)) {
                throw new SubsystemException("Unable to acquire the global mutual exclusion lock in time.");
            }
        }
        catch (InterruptedException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    public static void unlock() {
        lock.unlock();
    }

    public static void lock(Collection<BasicSubsystem> subsystems) {
        ArrayList<BasicSubsystem> locked = new ArrayList<BasicSubsystem>(subsystems.size());
        try {
            block2: while (locked.size() < subsystems.size()) {
                for (BasicSubsystem subsystem : subsystems) {
                    if (!subsystem.stateChangeLock().tryLock()) {
                        LockingStrategy.unlock(locked);
                        locked.clear();
                        if (condition.await(30000L, TimeUnit.SECONDS)) continue block2;
                        throw new SubsystemException("Unable to acquire the state change lock in time: " + subsystem);
                    }
                    locked.add(subsystem);
                }
            }
        }
        catch (InterruptedException e) {
            LockingStrategy.unlock(locked);
            throw new SubsystemException((Throwable)e);
        }
    }

    public static void unlock(Collection<BasicSubsystem> subsystems) {
        for (BasicSubsystem subsystem : subsystems) {
            subsystem.stateChangeLock().unlock();
        }
        LockingStrategy.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void signalAll() {
        LockingStrategy.lock();
        try {
            condition.signalAll();
        }
        finally {
            LockingStrategy.unlock();
        }
    }

    public static boolean set(Subsystem.State state, BasicSubsystem subsystem) {
        Map<Subsystem.State, Set<BasicSubsystem>> map = local.get();
        Set<BasicSubsystem> subsystems = map.get(state);
        if (subsystems == null) {
            subsystems = new HashSet<BasicSubsystem>();
            map.put(state, subsystems);
            local.set(map);
        }
        if (subsystems.contains(subsystem)) {
            return false;
        }
        subsystems.add(subsystem);
        return true;
    }

    public static void unset(Subsystem.State state, BasicSubsystem subsystem) {
        Map<Subsystem.State, Set<BasicSubsystem>> map = local.get();
        Set<BasicSubsystem> subsystems = map.get(state);
        if (subsystems != null) {
            subsystems.remove(subsystem);
        }
    }

    public static void readLock() {
        try {
            if (!rwlock.readLock().tryLock(30000L, TRY_LOCK_TIME_UNIT)) {
                throw new SubsystemException("Unable to acquire the global read lock in time.");
            }
        }
        catch (InterruptedException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    public static void readUnlock() {
        rwlock.readLock().unlock();
    }

    public static void writeLock() {
        try {
            if (!rwlock.writeLock().tryLock(30000L, TRY_LOCK_TIME_UNIT)) {
                throw new SubsystemException("Unable to acquire the global write lock in time.");
            }
        }
        catch (InterruptedException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    public static void writeUnlock() {
        rwlock.writeLock().unlock();
    }
}

