/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;

public class CustomResourceUninstaller
extends ResourceUninstaller {
    private final ServiceReference<ContentHandler> handlerRef;
    private final String type;

    public CustomResourceUninstaller(Resource resource, String type, BasicSubsystem subsystem, ServiceReference<ContentHandler> handlerRef) {
        super(resource, subsystem);
        this.handlerRef = handlerRef;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        this.removeReference();
        try {
            ContentHandler handler = (ContentHandler)this.subsystem.getBundleContext().getService(this.handlerRef);
            if (handler != null) {
                handler.uninstall(ResourceHelper.getSymbolicNameAttribute(this.resource), this.type, (Subsystem)this.subsystem);
            }
        }
        finally {
            this.subsystem.getBundleContext().ungetService(this.handlerRef);
        }
    }
}

