/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.subsystem.core.archive.CapabilityHeader;
import org.apache.aries.subsystem.core.archive.ExportPackageHeader;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.HeaderFactory;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.PreferredProviderHeader;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemLocalizationHeader;
import org.apache.aries.subsystem.core.archive.SubsystemSymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.SubsystemTypeHeader;
import org.apache.aries.subsystem.core.archive.SubsystemVersionHeader;
import org.apache.aries.subsystem.core.internal.OsgiIdentityCapability;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class SubsystemManifest {
    public static final String EXPORT_PACKAGE = "Export-Package";
    public static final String IMPORT_PACKAGE = "Import-Package";
    public static final String PREFERRED_PROVIDER = "Preferred-Provider";
    public static final String PROVIDE_CAPABILITY = "Provide-Capability";
    public static final String REQUIRE_BUNDLE = "Require-Bundle";
    public static final String REQUIRE_CAPABILITY = "Require-Capability";
    public static final String SUBSYSTEM_CONTENT = "Subsystem-Content";
    public static final String SUBSYSTEM_DESCRIPTION = "Subsystem-Description";
    public static final String SUBSYSTEM_EXPORTSERVICE = "Subsystem-ExportService";
    public static final String SUBSYSTEM_IMPORTSERVICE = "Subsystem-ImportService";
    public static final String SUBSYTEM_LOCALIZATION = "Subsystem-Localization";
    public static final String SUBSYSTEM_MANIFESTVERSION = "Subsystem-ManifestVersion";
    public static final String SUBSYSTEM_NAME = "Subsystem-Name";
    public static final String SUBSYSTEM_SYMBOLICNAME = "Subsystem-SymbolicName";
    public static final String SUBSYSTEM_TYPE = "Subsystem-Type";
    public static final String SUBSYSTEM_VERSION = "Subsystem-Version";
    private final Map<String, Header<?>> headers;

    private static Map<String, Header<?>> parseHeaders(Manifest manifest) {
        HashMap result = new HashMap();
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            String key = String.valueOf(entry.getKey());
            result.put(key, HeaderFactory.createHeader(key, String.valueOf(entry.getValue())));
        }
        return result;
    }

    private static void fillInDefaults(Map<String, Header<?>> headers) {
        Header<?> header = headers.get(SUBSYSTEM_VERSION);
        if (header == null) {
            headers.put(SUBSYSTEM_VERSION, SubsystemVersionHeader.DEFAULT);
        }
        if ((header = headers.get(SUBSYSTEM_TYPE)) == null) {
            headers.put(SUBSYSTEM_TYPE, SubsystemTypeHeader.DEFAULT);
        }
        if ((header = headers.get(SUBSYTEM_LOCALIZATION)) == null) {
            headers.put(SUBSYTEM_LOCALIZATION, SubsystemLocalizationHeader.DEFAULT);
        }
    }

    private SubsystemManifest(Map<String, Header<?>> headers) {
        HashMap map = new HashMap(headers);
        SubsystemManifest.fillInDefaults(map);
        this.headers = Collections.unmodifiableMap(map);
    }

    public SubsystemManifest(Manifest manifest) {
        this(SubsystemManifest.parseHeaders(manifest));
    }

    public SubsystemManifest(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public SubsystemManifest(InputStream in) throws IOException {
        Manifest manifest = ManifestProcessor.parseManifest((InputStream)in);
        Attributes attributes = manifest.getMainAttributes();
        HashMap headers = new HashMap(attributes.size() + 4);
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = String.valueOf(entry.getKey());
            headers.put(key, HeaderFactory.createHeader(key, String.valueOf(entry.getValue())));
        }
        SubsystemManifest.fillInDefaults(headers);
        this.headers = Collections.unmodifiableMap(headers);
    }

    public SubsystemManifest(String symbolicName, Version version, Collection<Resource> content) {
        this(null, symbolicName, version, content);
    }

    public SubsystemManifest(SubsystemManifest manifest, String symbolicName, Version version, Collection<Resource> content) {
        HashMap<Object, Object> headers = manifest == null ? new HashMap(4) : new HashMap(manifest.headers);
        Header header = (Header)headers.get(SUBSYSTEM_SYMBOLICNAME);
        if (header == null) {
            headers.put(SUBSYSTEM_SYMBOLICNAME, new SubsystemSymbolicNameHeader(symbolicName));
        }
        if ((header = (Header)headers.get(SUBSYSTEM_VERSION)) == null && version != null) {
            headers.put(SUBSYSTEM_VERSION, new SubsystemVersionHeader(version));
        }
        if ((header = (Header)headers.get(SUBSYSTEM_CONTENT)) == null && content != null && !content.isEmpty()) {
            headers.put(SUBSYSTEM_CONTENT, SubsystemContentHeader.newInstance(content));
        }
        SubsystemManifest.fillInDefaults(headers);
        this.headers = Collections.unmodifiableMap(headers);
    }

    public Map<String, Header<?>> getHeaders() {
        return this.headers;
    }

    public ExportPackageHeader getExportPackageHeader() {
        return (ExportPackageHeader)this.getHeaders().get(EXPORT_PACKAGE);
    }

    public ImportPackageHeader getImportPackageHeader() {
        return (ImportPackageHeader)this.getHeaders().get(IMPORT_PACKAGE);
    }

    public PreferredProviderHeader getPreferredProviderHeader() {
        return (PreferredProviderHeader)this.getHeaders().get(PREFERRED_PROVIDER);
    }

    public ProvideCapabilityHeader getProvideCapabilityHeader() {
        return (ProvideCapabilityHeader)this.getHeaders().get(PROVIDE_CAPABILITY);
    }

    public RequireBundleHeader getRequireBundleHeader() {
        return (RequireBundleHeader)this.getHeaders().get(REQUIRE_BUNDLE);
    }

    public RequireCapabilityHeader getRequireCapabilityHeader() {
        return (RequireCapabilityHeader)this.getHeaders().get(REQUIRE_CAPABILITY);
    }

    public SubsystemContentHeader getSubsystemContentHeader() {
        return (SubsystemContentHeader)this.getHeaders().get(SUBSYSTEM_CONTENT);
    }

    public SubsystemExportServiceHeader getSubsystemExportServiceHeader() {
        return (SubsystemExportServiceHeader)this.getHeaders().get(SUBSYSTEM_EXPORTSERVICE);
    }

    public SubsystemImportServiceHeader getSubsystemImportServiceHeader() {
        return (SubsystemImportServiceHeader)this.getHeaders().get(SUBSYSTEM_IMPORTSERVICE);
    }

    public SubsystemLocalizationHeader getSubsystemLocalizationHeader() {
        return (SubsystemLocalizationHeader)this.getHeaders().get(SUBSYTEM_LOCALIZATION);
    }

    public SubsystemSymbolicNameHeader getSubsystemSymbolicNameHeader() {
        return (SubsystemSymbolicNameHeader)this.getHeaders().get(SUBSYSTEM_SYMBOLICNAME);
    }

    public SubsystemTypeHeader getSubsystemTypeHeader() {
        return (SubsystemTypeHeader)this.getHeaders().get(SUBSYSTEM_TYPE);
    }

    public SubsystemVersionHeader getSubsystemVersionHeader() {
        return (SubsystemVersionHeader)this.getHeaders().get(SUBSYSTEM_VERSION);
    }

    public List<Capability> toCapabilities(Resource resource) {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (Header<?> header : this.headers.values()) {
            if (!(header instanceof CapabilityHeader)) continue;
            capabilities.addAll(((CapabilityHeader)header).toCapabilities(resource));
        }
        capabilities.add(new OsgiIdentityCapability(resource, this.getSubsystemSymbolicNameHeader().getSymbolicName(), this.getSubsystemVersionHeader().getVersion(), this.getSubsystemTypeHeader().getType()));
        capabilities.trimToSize();
        return capabilities;
    }

    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (Header<?> header : this.headers.values()) {
            if (!(header instanceof RequirementHeader) || header instanceof SubsystemContentHeader || header instanceof PreferredProviderHeader) continue;
            requirements.addAll(((RequirementHeader)header).toRequirements(resource));
        }
        requirements.trimToSize();
        return requirements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[Subsystem Manifest: ");
        Iterator<Header<?>> iterator = this.headers.values().iterator();
        if (iterator.hasNext()) {
            Header<?> header = iterator.next();
            builder.append(header.getName()).append('=').append(header.getValue());
            while (iterator.hasNext()) {
                header = iterator.next();
                builder.append(", ").append(header.getName()).append('=').append(header.getValue());
            }
        }
        return builder.append(']').toString();
    }

    public void write(OutputStream out) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        for (Map.Entry<String, Header<?>> entry : this.headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue().getValue());
        }
        manifest.write(out);
    }

    public int hashCode() {
        return 527 + ((Object)this.headers).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsystemManifest)) {
            return false;
        }
        SubsystemManifest that = (SubsystemManifest)o;
        return ((Object)that.headers).equals(this.headers);
    }

    public static class Builder {
        private Map<String, Header<?>> headers = new HashMap();

        public SubsystemManifest build() {
            return new SubsystemManifest(this.headers);
        }

        public Builder content(String value) {
            return value == null ? this : this.content(new SubsystemContentHeader(value));
        }

        public Builder content(Collection<Resource> value) {
            return value == null || value.isEmpty() ? this : this.content(SubsystemContentHeader.newInstance(value));
        }

        public Builder content(SubsystemContentHeader value) {
            return this.header(value);
        }

        public Builder header(Header<?> value) {
            if (value != null) {
                this.headers.put(value.getName(), value);
            }
            return this;
        }

        public Builder manifest(SubsystemManifest value) {
            for (Map.Entry<String, Header<?>> entry : value.getHeaders().entrySet()) {
                this.header(entry.getValue());
            }
            return this;
        }

        public Builder symbolicName(String value) {
            return value == null ? this : this.symbolicName(new SubsystemSymbolicNameHeader(value));
        }

        public Builder symbolicName(SubsystemSymbolicNameHeader value) {
            return this.header(value);
        }

        public Builder type(String value) {
            return value == null ? this : this.type(new SubsystemTypeHeader(value));
        }

        public Builder type(SubsystemTypeHeader value) {
            return this.header(value);
        }

        public Builder version(String value) {
            return value == null ? this : this.version(Version.parseVersion((String)value));
        }

        public Builder version(Version value) {
            return value == null ? this : this.version(new SubsystemVersionHeader(value));
        }

        public Builder version(SubsystemVersionHeader value) {
            return this.header(value);
        }
    }
}

