/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.DeployedVersionAttribute;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.ProvisionResourceRequirement;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ProvisionResourceHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Provision-Resource";

    public static ProvisionResourceHeader newInstance(Collection<Resource> resources) {
        StringBuilder builder = new StringBuilder();
        for (Resource resource : resources) {
            ProvisionResourceHeader.appendResource(resource, builder);
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return new ProvisionResourceHeader(builder.toString());
    }

    private static StringBuilder appendResource(Resource resource, StringBuilder builder) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        builder.append(symbolicName).append(';').append("deployed-version").append('=').append(version.toString()).append(';').append("type").append('=').append(type).append(';').append("resourceId").append('=').append(Utils.getId(resource));
        return builder;
    }

    public ProvisionResourceHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public ProvisionResourceHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public boolean contains(Resource resource) {
        for (Clause clause : this.getClauses()) {
            if (!clause.contains(resource)) continue;
            return true;
        }
        return false;
    }

    public Clause getClause(Resource resource) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        for (Clause clause : this.clauses) {
            if (!symbolicName.equals(clause.getPath()) || !clause.getDeployedVersion().equals((Object)version) || !type.equals(clause.getType())) continue;
            return clause;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_DEPLOYEDVERSION = "deployed-version";
        public static final String ATTRIBUTE_RESOURCEID = "resourceId";
        public static final String ATTRIBUTE_TYPE = "type";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, false), Clause.generateDefaultParameters(TypeAttribute.DEFAULT));
        }

        public Clause(Resource resource) {
            this(ProvisionResourceHeader.appendResource(resource, new StringBuilder()).toString());
        }

        public boolean contains(Resource resource) {
            return this.getSymbolicName().equals(ResourceHelper.getSymbolicNameAttribute(resource)) && this.getDeployedVersion().equals((Object)ResourceHelper.getVersionAttribute(resource)) && this.getType().equals(ResourceHelper.getTypeAttribute(resource));
        }

        public Version getDeployedVersion() {
            return ((DeployedVersionAttribute)this.getAttribute(ATTRIBUTE_DEPLOYEDVERSION)).getVersion();
        }

        public String getSymbolicName() {
            return this.path;
        }

        public String getType() {
            return ((TypeAttribute)this.getAttribute(ATTRIBUTE_TYPE)).getType();
        }

        public ProvisionResourceRequirement toRequirement(Resource resource) {
            return new ProvisionResourceRequirement(this, resource);
        }
    }
}

