/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.OsgiExecutionEnvironmentRequirement;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class BundleRequiredExecutionEnvironmentHeader
implements RequirementHeader<Clause> {
    public static final String NAME = "Bundle-RequiredExecutionEnvironment";
    private final Collection<Clause> clauses;

    public BundleRequiredExecutionEnvironmentHeader(String value) {
        ClauseTokenizer tokenizer = new ClauseTokenizer(value);
        this.clauses = new ArrayList<Clause>(tokenizer.getClauses().size());
        for (String clause : tokenizer.getClauses()) {
            this.clauses.add(new Clause(clause));
        }
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableCollection(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    @Override
    public List<? extends Requirement> toRequirements(Resource resource) {
        return Collections.singletonList(new OsgiExecutionEnvironmentRequirement(this.getClauses(), resource));
    }

    public String toString() {
        return this.getValue();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        private final ExecutionEnvironment executionEnvironment;
        private final String path;

        public Clause(String clause) {
            this.path = clause;
            this.executionEnvironment = new ExecutionEnvironment.Parser().parse(clause);
        }

        @Override
        public Attribute getAttribute(String name) {
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public Directive getDirective(String name) {
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            return Collections.emptyList();
        }

        public ExecutionEnvironment getExecutionEnvironment() {
            return this.executionEnvironment;
        }

        @Override
        public Parameter getParameter(String name) {
            return null;
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public OsgiExecutionEnvironmentRequirement toRequirement(Resource resource) {
            return new OsgiExecutionEnvironmentRequirement(this, resource);
        }

        public String toString() {
            return this.getPath();
        }

        public static class ExecutionEnvironment {
            private final String name;
            private final Version version;

            public ExecutionEnvironment(String name) {
                this(name, null);
            }

            public ExecutionEnvironment(String name, Version version) {
                if (name == null) {
                    throw new NullPointerException();
                }
                this.name = name;
                this.version = version;
            }

            public String getName() {
                return this.name;
            }

            public Version getVersion() {
                return this.version;
            }

            public static class Parser {
                private static final String BREE = "((?:[0-9]|[A-Za-z]|_|-)+)(?:-([0-9]+(?:\\.[0-9]+(?:\\.[0-9]+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)?)?)?))?(?:/((?:[0-9]|[A-Za-z]|_|-)+)(?:-([0-9]+(?:\\.[0-9]+(?:\\.[0-9]+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)?)?)?))?)?";
                private static final Pattern PATTERN = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-)+)(?:-([0-9]+(?:\\.[0-9]+(?:\\.[0-9]+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)?)?)?))?(?:/((?:[0-9]|[A-Za-z]|_|-)+)(?:-([0-9]+(?:\\.[0-9]+(?:\\.[0-9]+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)?)?)?))?)?");

                public ExecutionEnvironment parse(String clause) {
                    Matcher matcher = PATTERN.matcher(clause);
                    if (matcher.matches() && this.versionsMatch(matcher)) {
                        return new ExecutionEnvironment(this.computeName(matcher), this.computeVersion(matcher));
                    }
                    return new ExecutionEnvironment(clause);
                }

                private String computeName(Matcher matcher) {
                    return this.computeName(matcher.group(1), matcher.group(3));
                }

                private String computeName(String left, String right) {
                    if (left.equalsIgnoreCase("J2SE")) {
                        left = "JavaSE";
                    }
                    if (right == null) {
                        return left;
                    }
                    return left + '/' + right;
                }

                private Version computeVersion(Matcher matcher) {
                    String version = matcher.group(2);
                    if (version == null) {
                        version = matcher.group(4);
                    }
                    if (version == null) {
                        return null;
                    }
                    return Version.parseVersion((String)version);
                }

                private boolean versionsMatch(Matcher matcher) {
                    String version1 = matcher.group(2);
                    String version2 = matcher.group(4);
                    if (version1 == null || version2 == null) {
                        return true;
                    }
                    return version1.equals(version2);
                }
            }
        }
    }
}

