/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Clause;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.GenericClause;
import org.apache.aries.subsystem.core.archive.Header;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public abstract class AbstractHeader
implements Header<Clause> {
    protected final List<Clause> clauses;
    protected final String name;
    protected final String value;

    protected static void appendResource(Resource resource, StringBuilder builder) {
        Map attributes = ((Capability)resource.getCapabilities("osgi.identity").get(0)).getAttributes();
        String symbolicName = (String)attributes.get("osgi.identity");
        Version version = (Version)attributes.get("version");
        String namespace = (String)attributes.get("type");
        builder.append(symbolicName).append(';').append("deployed-version").append('=').append(version.toString()).append(';').append("type").append('=').append(namespace);
    }

    public AbstractHeader(String name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        ClauseTokenizer tokenizer = new ClauseTokenizer(value);
        ArrayList<GenericClause> clauses = new ArrayList<GenericClause>(tokenizer.getClauses().size());
        for (String clause : tokenizer.getClauses()) {
            clauses.add(new GenericClause(clause));
        }
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("Invalid header syntax -> " + name + ": " + value);
        }
        this.name = name;
        this.value = value;
        this.clauses = Collections.synchronizedList(clauses);
    }

    @Override
    public List<Clause> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHeader)) {
            return false;
        }
        AbstractHeader that = (AbstractHeader)o;
        return that.name.equals(this.name) && ((Object)that.clauses).equals(this.clauses);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ((Object)this.clauses).hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getName() + ": name=" + this.name + ", value=" + this.value;
    }
}

