/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.monitor;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.servlet.event.ApplicationEvent;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.event.ServletInvocationEvent;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.monitor.WebAppModule;
import com.ibm.ws.webcontainer.monitor.WebAppPerf;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.webcontainer.async.WSAsyncEvent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.RequestUtils;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class WebAppMonitorListener
implements ServletListener,
ServletInvocationListener,
ServletErrorListener,
ApplicationListener,
AsyncListener {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.WebAppPmiListener";
    J2EEName _appName = null;
    private static final String defaultJ2eeNameStr = "defaultJ2eeNameStr";
    boolean areAppAggregatesInited = false;
    WebAppPerf appPmi = null;
    private static final int APP_PMI_NULL = 0;
    private static final int APP_PMI_SMF = 1;
    private static final int APP_PMI_WEB = 2;
    private int appPmiState = 0;

    public void onApplicationAvailableForService(ApplicationEvent evt) {
        if (!this.areAppAggregatesInited) {
            this.initializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
    }

    public void onApplicationUnavailableForService(ApplicationEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onApplicationUnavailableForService();
        }
    }

    public void onApplicationStart(ApplicationEvent evt) {
        WebApp webApp = (WebApp)evt.getSource();
        WebModuleMetaData mmd = webApp.getModuleMetaData();
        this._appName = mmd.getJ2EEName();
        if (!this.areAppAggregatesInited) {
            this.initializeAppCounters(mmd.getName());
            this.areAppAggregatesInited = true;
        }
        if (this.appPmi != null) {
            this.appPmi.onApplicationStart();
        }
    }

    public void onApplicationEnd(ApplicationEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onApplicationEnd();
        }
    }

    public void onServletStartService(ServletInvocationEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            HttpServletRequest hReq = evt.getRequest();
            if (hReq == null) {
                this.appPmi.onServletStartService(evt.getServletName(), null);
            } else {
                this.appPmi.onServletStartService(evt.getServletName(), RequestUtils.getURIForCurrentDispatch((HttpServletRequest)evt.getRequest()));
            }
        }
    }

    public void onServletFinishService(ServletInvocationEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            HttpServletRequest hReq = evt.getRequest();
            if (hReq == null) {
                this.appPmi.onServletFinishService(evt.getServletName(), evt.getResponseTime(), null);
            } else {
                this.appPmi.onServletFinishService(evt.getServletName(), evt.getResponseTime(), RequestUtils.getURIForCurrentDispatch((HttpServletRequest)evt.getRequest()));
            }
        }
    }

    public void onServletStartInit(ServletEvent evt) {
        if (this.isStatisticsEnabled(evt)) {
            ComponentMetaData obj = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            String j2eeNameStr = null;
            if (obj instanceof WebComponentMetaData) {
                WebComponentMetaData cmd = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                J2EEName j2eeName = cmd.getJ2EEName();
                j2eeNameStr = cmd.getName();
            }
            if (j2eeNameStr == null) {
                j2eeNameStr = defaultJ2eeNameStr;
            }
            this.checkAppCounters();
            if (this.appPmi != null) {
                this.appPmi.onServletStartInit(j2eeNameStr, evt.getServletName());
            }
        }
    }

    public void onServletFinishInit(ServletEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletFinishInit(evt.getServletName());
        }
    }

    public void onServletStartDestroy(ServletEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletStartDestroy(evt.getServletName());
        }
    }

    public void onServletFinishDestroy(ServletEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletFinishDestroy(evt.getServletName());
        }
    }

    public void onServletUnloaded(ServletEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletUnloaded(evt.getServletName());
        }
    }

    public void onServletAvailableForService(ServletEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletAvailableForService(evt.getServletName());
        }
    }

    public void onServletUnavailableForService(ServletEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletUnavailableForService(evt.getServletName());
        }
    }

    public void onServletInitError(ServletErrorEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletInitError(evt.getServletName());
        }
    }

    public void onServletServiceError(ServletErrorEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletServiceError(evt.getServletName());
        }
    }

    public void onServletServiceDenied(ServletErrorEvent evt) {
        this.checkAppCounters();
        if (this.appPmi != null) {
            this.appPmi.onServletServiceDenied(evt.getServletName());
        }
    }

    public void onServletDestroyError(ServletErrorEvent evt) {
        this.checkAppCounters();
        if (evt != null && evt.getServletName() != null && this.appPmi != null) {
            this.appPmi.onServletDestroyError(evt.getServletName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeAppCounters(String appName) {
        if (StatsFactory.isPMIEnabled()) {
            WebAppMonitorListener webAppMonitorListener = this;
            synchronized (webAppMonitorListener) {
                this.appPmi = new WebAppModule(appName, true);
                this.appPmiState = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAppCounters() {
        if (this.appPmiState != 2) {
            WebAppMonitorListener webAppMonitorListener = this;
            synchronized (webAppMonitorListener) {
                if (this.appPmiState != 2) {
                    this.appPmi = new WebAppModule(this.getAppName(), true);
                    this.appPmiState = 2;
                }
            }
        }
    }

    public boolean isStatisticsEnabled(ServletEvent evt) {
        Object evtSrc = evt.getSource();
        if (evtSrc instanceof IServletWrapper) {
            IServletConfig sConfig = ((IServletWrapper)evtSrc).getServletConfig();
            if (sConfig == null || sConfig.isStatisticsEnabled()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isStatisticsEnabled", "pmi enabled for the servlet-->[" + evt.getServletName() + "]");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isStatisticsEnabled", "pmi disabled for the servlet-->[" + evt.getServletName() + "]");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isStatisticsEnabled", "Event Source is not a ServletWrapper, we have to assume statistics enabled is true");
        }
        return true;
    }

    public String getAppName() {
        return this._appName.toString();
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this.checkAppCounters();
        if (this.appPmi != null) {
            ServletRequest request = asyncEvent.getSuppliedRequest();
            if (request == null) {
                request = asyncEvent.getAsyncContext().getRequest();
            }
            long responseTime = ((WSAsyncEvent)asyncEvent).getElapsedTime();
            IExtendedRequest iExtReq = ServletUtil.unwrapRequest((ServletRequest)request);
            String servletName = iExtReq.getWebAppDispatcherContext().getCurrentServletReference().getName();
            Object httpReq = null;
            httpReq = request instanceof HttpServletRequest ? (HttpServletRequest)request : iExtReq;
            this.appPmi.onAsyncContextComplete(servletName, responseTime, RequestUtils.getURIForCurrentDispatch((HttpServletRequest)httpReq));
        }
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
    }
}

