/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IDGenerator {
    private int _sessionIDLength = 0;
    private static final char[] sBitChars = new char[]{'G', '9', 'U', 'i', 'b', 'w', '-', '8', '6', 'z', 'u', 'p', 'J', 'R', 'S', 'h', 'K', '5', 'n', 'c', '4', 'C', 't', 'I', 'W', '7', 'F', 'e', 'M', 'g', 'q', '2', '3', 'V', 'Z', 'k', 'O', 'D', 'a', 'v', 'y', 'Y', 'P', 'X', 'E', 'N', '1', 'f', 'l', 'B', '0', 'L', 's', 'o', 'A', 'T', 'd', 'x', 'm', 'r', 'Q', '_', 'j', 'H'};
    private static final int[] sSecondByteMasks = new int[]{0, 1, 3, 7, 15, 31, 63};
    private SecureRandom _random = null;
    private int _byteArraySize = 0;
    private static final TraceComponent tc = Tr.register(IDGenerator.class);
    static final long serialVersionUID = -1755211991056677711L;

    public IDGenerator() {
        this(23);
    }

    @FFDCIgnore(value={Exception.class})
    public IDGenerator(int sessionIDLength) {
        this._sessionIDLength = sessionIDLength;
        this._byteArraySize = sessionIDLength * 6 / 8 + 1;
        String jceProvider = IDGenerator.getSystemProperty("DEFAULT_JCE_PROVIDER");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JCE Provider is " + jceProvider), (Object[])new Object[0]);
        }
        try {
            this._random = SecureRandom.getInstance("IBMSecureRandom", jceProvider);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionIdGeneratorImpl.UsingDefaultSecureRandom", (Object[])new Object[0]);
            }
            this._random = new SecureRandom();
        }
        byte[] genBytes = new byte[this._byteArraySize];
        this._random.nextBytes(genBytes);
        this._random.setSeed(System.currentTimeMillis());
        this._random.setSeed(Thread.currentThread().getName().hashCode());
    }

    public static String getSystemProperty(final String key) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -2898203446716167491L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return Security.getProperty(key);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return value;
    }

    public String getID() {
        byte[] genBytes = new byte[this._byteArraySize];
        this._random.nextBytes(genBytes);
        String id = IDGenerator.convertSessionIdBytesToSessionId(genBytes, this._sessionIDLength);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sessionID=" + id), (Object[])new Object[0]);
        }
        return id;
    }

    public static String convertSessionIdBytesToSessionId(byte[] pBytes, int sessionIdLength) {
        char[] chars = new char[sessionIdLength];
        int byteNum = 0;
        int bitNum = 0;
        int pos = 0;
        while (byteNum < pBytes.length && pos < sessionIdLength) {
            int val = 0;
            if (bitNum < 3) {
                val = pBytes[byteNum] >> 2 - bitNum & 0x3F;
            } else {
                val = pBytes[byteNum] << 6 - (8 - bitNum);
                if (byteNum + 1 < pBytes.length) {
                    int secondVal = (pBytes[byteNum + 1] & 0xFF) >> 8 - (6 - (8 - bitNum));
                    val |= (secondVal &= sSecondByteMasks[6 - (8 - bitNum)]);
                }
                val &= 0x3F;
            }
            chars[pos++] = sBitChars[val];
            if ((bitNum += 6) < 8) continue;
            ++byteNum;
            bitNum -= 8;
        }
        return new String(chars);
    }
}

