/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ByteGenerator {
    private SecureRandom _random = null;
    private final int _byteArraySize = 4;
    private final int _keyArraySize = 16;
    private static final TraceComponent tc = Tr.register(ByteGenerator.class);
    static final long serialVersionUID = 5298481683009259532L;

    @FFDCIgnore(value={Exception.class})
    public ByteGenerator() {
        String jceProvider = ByteGenerator.getSystemProperty("DEFAULT_JCE_PROVIDER");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JCE Provider is " + jceProvider), (Object[])new Object[0]);
        }
        try {
            this._random = SecureRandom.getInstance("IBMSecureRandom", jceProvider);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionIdGeneratorImpl.UsingDefaultSecureRandom", (Object[])new Object[0]);
            }
            this._random = new SecureRandom();
        }
        byte[] genBytes = new byte[4];
        this._random.nextBytes(genBytes);
        this._random.setSeed(System.currentTimeMillis());
        this._random.setSeed(Thread.currentThread().getName().hashCode());
    }

    public static String getSystemProperty(final String key) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 2580472973403118071L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return Security.getProperty(key);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return value;
    }

    public byte[] getID() {
        byte[] genBytes = new byte[4];
        this._random.nextBytes(genBytes);
        return genBytes;
    }

    public byte[] getWebsocketKey() {
        byte[] genBytes = new byte[16];
        this._random.nextBytes(genBytes);
        return genBytes;
    }
}

