/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.internal.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HandlerPath {
    private static final TraceComponent tc = Tr.register(HandlerPath.class);
    final String registeredPath;
    public final Pattern pattern;
    int length;
    final boolean hidden;
    static final long serialVersionUID = 5058722712517979579L;

    public HandlerPath(String registeredPath) {
        this(registeredPath, false);
    }

    public HandlerPath(String registeredPath, boolean hidden) {
        this.hidden = hidden;
        if (registeredPath.charAt(registeredPath.length() - 1) == '/') {
            registeredPath = registeredPath.substring(0, registeredPath.length() - 1);
        }
        this.registeredPath = registeredPath;
        this.length = -1;
        this.pattern = registeredPath.contains("{") ? this.processPattern(registeredPath) : null;
    }

    public boolean containsVariable() {
        return this.pattern != null;
    }

    public String getRegisteredPath() {
        return this.registeredPath;
    }

    public int length() {
        if (this.length == -1) {
            this.length = this.pattern == null ? this.registeredPath.length() : this.registeredPath.replaceAll("(\\{\\w*\\})", "").length();
        }
        return this.length;
    }

    public boolean matches(String url) {
        if (this.pattern == null) {
            if (!url.startsWith(this.registeredPath)) {
                return false;
            }
            char nextChar = url.charAt(this.registeredPath.length());
            return nextChar == '/' || nextChar == '?';
        }
        return this.pattern.matcher(url).matches();
    }

    public Map<String, String> mapVariables(String matchedPath) {
        if (this.pattern != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            Matcher matcherValue = this.pattern.matcher(matchedPath);
            Matcher matcherKey = this.pattern.matcher(this.registeredPath);
            matcherValue.matches();
            matcherKey.matches();
            if (matcherValue.groupCount() != matcherKey.groupCount() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Handler path matched expression groups did not match. Matched path: " + matchedPath + " | Registered path:" + this.registeredPath), (Object[])new Object[0]);
            }
            for (int i = 1; i <= matcherValue.groupCount(); ++i) {
                String key = matcherKey.group(i);
                key = key.substring(1, key.length() - 1);
                String value = matcherValue.group(i);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Mapping key: " + key + " to value: " + value), (Object[])new Object[0]);
                }
                map.put(key, value);
            }
            return map;
        }
        return null;
    }

    private Pattern processPattern(String registered) {
        String patternRegex = registered.replaceAll("(\\{\\w+\\})", "(.+)") + "[\\?/]?.*";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Generated regex: " + patternRegex), (Object[])new Object[0]);
        }
        return Pattern.compile(patternRegex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HandlerPath)) {
            return false;
        }
        HandlerPath otherPath = (HandlerPath)obj;
        return this.registeredPath == otherPath.registeredPath || this.registeredPath.equals(otherPath.registeredPath);
    }

    public int hashCode() {
        return this.registeredPath.hashCode();
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

