/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.lifecycle.metadata;

import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.wink.server.internal.lifecycle.metadata.EJBBeanMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBMetadata {
    private static final Logger logger = LoggerFactory.getLogger(EJBMetadata.class);
    public static final String EJB_METADATA_KEY = "WINK_EJB_METADATA_KEY";
    private Map<String, EJBBeanMetadata> ejbMetadata;

    public Map<String, EJBBeanMetadata> getEjbMetadata() {
        return this.ejbMetadata;
    }

    public void setEjbMetadata(Map<String, EJBBeanMetadata> ejbMetadata) {
        this.ejbMetadata = ejbMetadata;
    }

    public static boolean isEJB(ServletContext servletContext, Class<?> clazz) {
        if (servletContext == null || clazz == null) {
            return false;
        }
        EJBMetadata metadata = (EJBMetadata)servletContext.getAttribute(EJB_METADATA_KEY);
        return EJBMetadata.isEJB(metadata, clazz);
    }

    public static boolean isEJB(EJBMetadata metadata, Class<?> clazz) {
        if (metadata == null || metadata.getEjbMetadata() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("No EJBMetadata exists on the servlet context.");
            }
            return false;
        }
        EJBBeanMetadata beanMetdata = metadata.getEjbMetadata().get(clazz.getName());
        boolean isEJB = beanMetdata != null;
        return isEJB;
    }
}

