/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.lifecycle;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.server.internal.lifecycle.metadata.EJBBeanMetadata;
import org.apache.wink.server.internal.lifecycle.metadata.EJBMetadata;
import org.apache.wink.server.internal.log.EJBs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBLifecycleManager<T>
implements LifecycleManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(EJBLifecycleManager.class);
    private EJBMetadata metadata = null;
    private boolean inited = false;
    private final InitialContext ic;
    private final ServletContext servletContext;

    public EJBLifecycleManager(ServletContext servletContext) {
        this.servletContext = servletContext;
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException e) {
            logger.error(Messages.getMessage("failedServletContextCreation", e.getMessage()), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @Override
    public ObjectFactory<T> createObjectFactory(Class<T> object) throws ObjectCreationException {
        if (logger.isTraceEnabled()) {
            logger.trace("entry {}", object);
        }
        boolean isEJB = false;
        EJBBeanMetadata beanMetdata = null;
        if (!this.inited) {
            if (logger.isTraceEnabled()) {
                logger.trace("Initializing the EJB metadata.");
            }
            this.metadata = (EJBMetadata)this.servletContext.getAttribute("WINK_EJB_METADATA_KEY");
            EJBs ejbs = new EJBs(this.metadata);
            ejbs.log();
            this.inited = true;
        }
        if (this.metadata == null || this.metadata.getEjbMetadata() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("No EJBMetadata exists on the servlet context. No processing of EJBs will be done.");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("exit {}", (Object)null);
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("object.getName(): {}", (Object)object.getName());
        }
        isEJB = EJBMetadata.isEJB(this.metadata, object);
        if (logger.isTraceEnabled()) {
            logger.trace("isEJB: {}", (Object)isEJB);
        }
        if (isEJB) {
            if (logger.isTraceEnabled()) {
                logger.trace("Class {} is an EJB. Creating an EJBObjectFactory.", object);
            }
            beanMetdata = this.metadata.getEjbMetadata().get(object.getName());
            String beanName = beanMetdata.getBeanName();
            String interfaceName = beanMetdata.getLocalBusinessInterface();
            String jndiLookup = "java:module/" + beanName;
            String ejbinjar = (String)this.servletContext.getAttribute("ejbmodulename.router");
            if (ejbinjar != null && !"".equalsIgnoreCase(ejbinjar)) {
                jndiLookup = "java:app/" + ejbinjar + "/" + beanName;
            }
            if (interfaceName != null) {
                jndiLookup = jndiLookup + "!" + interfaceName;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("java:module String is {}", (Object)jndiLookup);
            }
            return new EJBObjectFactory<T>(jndiLookup, object, this.ic);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Class {} is not an EJB.", object);
        }
        return null;
    }

    @Override
    public ObjectFactory<T> createObjectFactory(T object) throws ObjectCreationException {
        return null;
    }

    static String getJNDILookup(ObjectFactory<?> objectFactory) {
        if (!(objectFactory instanceof EJBObjectFactory)) {
            return null;
        }
        return ((EJBObjectFactory)objectFactory).getJNDILookup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EJBObjectFactory<T>
    implements ObjectFactory<T> {
        private final String jndiLookup;
        private final Class<T> clazz;
        private final InitialContext ic;
        private T ejb;

        public EJBObjectFactory(String jndiLookup, Class<T> clazz, InitialContext ic) {
            this.jndiLookup = jndiLookup;
            this.clazz = clazz;
            this.ic = ic;
        }

        @Override
        public T getInstance(RuntimeContext context) {
            if (this.ejb == null) {
                try {
                    this.ejb = this.ic.lookup(this.jndiLookup);
                }
                catch (NamingException e) {
                    logger.error(Messages.getMessage("failedJNDILookup", this.jndiLookup, e.getMessage()), (Throwable)e);
                    throw new WebApplicationException((Throwable)e);
                }
            }
            return this.ejb;
        }

        @Override
        public Class<T> getInstanceClass() {
            return this.clazz;
        }

        @Override
        public void releaseAll(RuntimeContext context) {
        }

        @Override
        public void releaseInstance(T instance, RuntimeContext context) {
        }

        String getJNDILookup() {
            return this.jndiLookup;
        }
    }
}

