/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers.ejb;

import javax.ejb.EJBException;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EJBExceptionHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(EJBExceptionHandler.class);

    protected void handleResponse(MessageContext context) throws Throwable {
        Object result = context.getResponseEntity();
        if (result instanceof EJBException) {
            EJBException exception = (EJBException)result;
            ExceptionMapper provider = context.getProviders().getExceptionMapper(exception.getClass());
            if (provider == null) {
                if (exception.getCause() != null) {
                    logger.trace("No provider was found to map exception {}. Putting the caused by Exception on the message context.", (Throwable)exception);
                    context.setResponseEntity(exception.getCausedByException());
                } else {
                    logger.trace("No provider was found to map exception {} and no cause was found on the EJBException. Putting the EJBException back on the context.", (Throwable)exception);
                }
            } else {
                logger.trace("Provider {} to map exception {} was found. Delegating to the PopulateErrorResponseHandler handler.", (Object)provider, (Object)exception);
            }
        }
    }
}

