/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateResponseMediaTypeHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(PopulateResponseMediaTypeHandler.class);
    private static final MediaType APPLICATION_TYPE = new MediaType("application", "*");
    private boolean errorFlow = false;

    public void handleResponse(MessageContext context) throws Throwable {
        MediaType responseMediaType = null;
        Object result = context.getResponseEntity();
        boolean debug = logger.isDebugEnabled();
        if (result == null) {
            if (debug) {
                logger.trace("No entity so no Content-Type needs to be set");
            }
            return;
        }
        if (result instanceof Response) {
            Response response = (Response)result;
            if (response.getEntity() == null) {
                if (debug) {
                    logger.trace("No entity so no Content-Type needs to be set");
                }
                return;
            }
            Object first = response.getMetadata().getFirst((Object)"Content-Type");
            if (first != null) {
                responseMediaType = first instanceof MediaType ? (MediaType)first : MediaType.valueOf((String)first.toString());
            }
            if (debug) {
                logger.trace("Content-Type was set by application to {}", (Object)responseMediaType);
            }
        }
        if (responseMediaType == null) {
            Set<MediaType> producedMime = null;
            SearchResult searchResult = context.getAttribute(SearchResult.class);
            if (searchResult != null && searchResult.isFound()) {
                MethodMetadata methodMetadata = searchResult.getMethod().getMetadata();
                producedMime = methodMetadata.getProduces();
                if (debug) {
                    logger.trace("Determining Content-Type from @Produces on method: {}", producedMime);
                }
            }
            if (producedMime == null || producedMime.isEmpty()) {
                if (result instanceof Response) {
                    Response response = (Response)result;
                    producedMime = context.getAttribute(ProvidersRegistry.class).getMessageBodyWriterMediaTypes(response.getEntity().getClass());
                    if (debug) {
                        logger.trace("Determining Content-Type from compatible generic type to {} from MessageBodyWriters: {}", response.getEntity().getClass(), producedMime);
                    }
                } else {
                    producedMime = context.getAttribute(ProvidersRegistry.class).getMessageBodyWriterMediaTypes(result.getClass());
                    if (debug) {
                        logger.trace("Determining Content-Type from compatible generic type to {} from MessageBodyWriters: {}", result.getClass(), producedMime);
                    }
                }
                if (debug) {
                    logger.debug(Messages.getMessage("populateResponseMediaTypeHandlerFromCompatibleMessageBodyWriters"));
                }
            }
            if (producedMime.isEmpty()) {
                producedMime.add(MediaType.WILDCARD_TYPE);
            }
            List acceptableMediaTypes = context.getHttpHeaders().getAcceptableMediaTypes();
            LinkedList<CandidateMediaType> candidates = new LinkedList<CandidateMediaType>();
            for (MediaType acceptableMediaType : acceptableMediaTypes) {
                for (MediaType mediaType : producedMime) {
                    String q;
                    CandidateMediaType candidate;
                    if (debug) {
                        logger.trace("Comparing {} to {}", (Object)acceptableMediaType, (Object)mediaType);
                    }
                    if (!mediaType.isCompatible(acceptableMediaType)) continue;
                    MediaType candidateMediaType = null;
                    candidateMediaType = MediaTypeUtils.compareTo(mediaType, acceptableMediaType) > 0 ? mediaType : acceptableMediaType;
                    if (debug) {
                        logger.trace("MediaType compatible so using candidate type {}", (Object)candidateMediaType);
                    }
                    if (Double.compare((candidate = new CandidateMediaType(candidateMediaType, q = (String)acceptableMediaType.getParameters().get("q"))).q, 0.0) == 0) continue;
                    if (debug) {
                        logger.trace("Candidate {} has q value {} so adding to possible candidates", (Object)candidate.getMediaType(), (Object)q);
                    }
                    candidates.add(candidate);
                }
            }
            if (candidates.isEmpty()) {
                if (this.isErrorFlow()) {
                    if (debug) {
                        logger.trace("Error flow and no candidates so not going to set a Content-Type");
                    }
                    return;
                }
                logger.info(Messages.getMessage("populateResponseMediaTypeHandlerNoAcceptableResponse"));
                throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
            }
            CandidateMediaType max = null;
            boolean useOctetStream = false;
            for (CandidateMediaType candidate : candidates) {
                if (max == null) {
                    max = candidate;
                    if (debug) {
                        logger.trace("No previous best candidate so using candidate {}", (Object)max.getMediaType());
                    }
                } else {
                    int comparison = MediaTypeUtils.compareTo(candidate.getMediaType(), max.getMediaType());
                    if (comparison > 0) {
                        max = candidate;
                        if (debug) {
                            logger.trace("Best candidate is now {} because it was a more specific media type", (Object)max.getMediaType());
                        }
                    } else if (comparison == 0 && candidate.getQ() > max.getQ()) {
                        max = candidate;
                        if (debug) {
                            logger.trace("Best candidate is now {} because it had a higher quality value {} compared to {} with quality value {}", new Object[]{max.getMediaType(), max.getQ(), candidate, candidate.getQ()});
                        }
                    }
                }
                if (useOctetStream || !candidate.getMediaType().equals((Object)MediaType.WILDCARD_TYPE) && !candidate.getMediaType().equals((Object)APPLICATION_TYPE)) continue;
                if (debug) {
                    logger.trace("If necessary, use an application/octet-stream because there is a wildcard", (Object)candidate.getMediaType());
                }
                useOctetStream = true;
            }
            if (!max.getMediaType().isWildcardSubtype()) {
                responseMediaType = max.getMediaType();
            } else if (useOctetStream) {
                if (debug) {
                    logger.trace("Content-Type was reset to application/octet-stream because it was either */* or was application/*");
                }
                responseMediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            } else {
                if (this.isErrorFlow()) {
                    if (debug) {
                        logger.trace("Error flow so not going to set a response Content-Type");
                    }
                    return;
                }
                logger.info(Messages.getMessage("populateResponseMediaTypeHandlerNoAcceptableResponse"));
                throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
            }
        }
        if (debug) {
            logger.trace("Response Content-Type will be set to {}", responseMediaType);
        }
        context.setResponseMediaType(responseMediaType);
    }

    public void setErrorFlow(boolean errorFlow) {
        this.errorFlow = errorFlow;
    }

    public boolean isErrorFlow() {
        return this.errorFlow;
    }

    private static class CandidateMediaType {
        private MediaType mediaType;
        private double q;

        public CandidateMediaType(MediaType mediaType, String q) {
            this.mediaType = mediaType;
            this.q = q != null ? Double.parseDouble(q) : 1.0;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public double getQ() {
            return this.q;
        }
    }
}

