/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.wink.common.internal.application.ApplicationExceptionAttribute;
import org.apache.wink.common.internal.log.LogUtils;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.log.ResourceInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeMethodHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(InvokeMethodHandler.class);

    public void handleRequest(MessageContext context) throws Throwable {
        Method javaMethod = null;
        Object instance = null;
        Object[] parameters = null;
        try {
            ResourceInvocation.ResourceInvocationData resInvocationData;
            SearchResult searchResult = context.getAttribute(SearchResult.class);
            javaMethod = searchResult.getMethod().getMetadata().getReflectionMethod();
            parameters = searchResult.getInvocationParameters();
            instance = searchResult.getResource().getInstance(context);
            if (logger.isTraceEnabled()) {
                logger.trace("Invoking method {} of declaring class {} on the instance of a class {}@{} with parameters {}", new Object[]{javaMethod.getName(), javaMethod.getDeclaringClass().getName(), instance.getClass().getName(), Integer.toHexString(System.identityHashCode(instance)), Arrays.toString(parameters)});
            }
            if ((resInvocationData = context.getAttribute(ResourceInvocation.ResourceInvocationData.class)) != null) {
                resInvocationData.addInvocation(context);
            }
            Object result = javaMethod.invoke(instance, parameters);
            context.setResponseEntity(result);
        }
        catch (InvocationTargetException ite) {
            try {
                String newLine = System.getProperty("line.separator");
                String debugMsg = String.format("%s with message \"%s\" was encountered during invocation of method %s of declaring class %s on the instance of a class %s@%s with parameters %s" + newLine + "%s", ite.getTargetException().getClass().getName(), ite.getTargetException().getMessage(), javaMethod == null ? "UNKNOWN" : javaMethod.getName(), javaMethod == null ? "UNKNOWN" : javaMethod.getDeclaringClass().getName(), instance == null ? "UNKNOWN" : instance.getClass().getName(), instance == null ? "UNKNOWN" : Integer.toHexString(System.identityHashCode(instance)), parameters == null ? "UNKNOWN" : Arrays.toString(parameters), LogUtils.stackToDebugString(ite.getTargetException()));
                context.setAttribute(ApplicationExceptionAttribute.class, new ApplicationExceptionAttribute(debugMsg));
            }
            catch (Throwable t) {
                logger.trace("Could not format log output for exception originating in provider.", t);
            }
            throw ite.getTargetException();
        }
    }
}

