/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.lifecycle.metadata.EJBMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationHandler.class);
    static boolean was_securityHelperLoaded = false;

    public void handleRequest(MessageContext context) throws Throwable {
        SearchResult searchResult = null;
        try {
            logger.trace("Entry into AuthorizationHandler handleRequest");
            searchResult = context.getAttribute(SearchResult.class);
            ServletContext servletContext = context.getAttribute(ServletContext.class);
            if (EJBMetadata.isEJB(servletContext, searchResult.getResource().getResourceClass())) {
                logger.trace("Exit from AuthorizationHandler handleRequest: found an EJB resource.");
                return;
            }
            MethodMetadata methodMetadata = searchResult.getMethod().getMetadata();
            if (methodMetadata == null || !methodMetadata.isSecurityAnnotated()) {
                logger.trace("Exit from AuthorizationHandler handleRequest: No Security annotations found. Allow access.");
                return;
            }
            logger.trace("AuthorizationHandler handleRequest checking for DenyAll");
            if (methodMetadata.isDenyAll()) {
                logger.trace("AuthorizationHandler handleRequest: DenyAll found");
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            logger.trace("AuthorizationHandler handleRequest checking for PermitAll");
            if (methodMetadata.isPermitAll()) {
                logger.trace("AuthorizationHandler handleRequest: PermitAll found");
                return;
            }
            logger.trace("AuthorizationHandler handleRequest checking for RolesAllowed");
            Object[] rolesAllowed = methodMetadata.getRolesAllowed();
            boolean isUserInRole = false;
            if (rolesAllowed != null) {
                logger.trace("AuthorizationHandler handleRequest: RolesAllowed found: {}", rolesAllowed);
                for (Object role : rolesAllowed) {
                    logger.trace("AuthorizationHandler handleRequest checking for this allowed role: {}", role);
                    isUserInRole = context.getAttribute(SecurityContext.class).isUserInRole((String)role);
                    if (!isUserInRole) continue;
                    logger.trace("AuthorizationHandler handleRequest: about to exit with role access granted through role {} ", role);
                    return;
                }
            }
            if (was_securityHelperLoaded) {
                logger.trace("AuthorizationHandler handleRequest: about to exit with access denied");
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
        }
        catch (WebApplicationException wae) {
            logger.trace("Authorization to resource failed for user: {} trying to access resource {}", (Object)context.getAttribute(SecurityContext.class).getUserPrincipal(), (Object)searchResult.getResource());
            throw wae;
        }
    }

    public static boolean isWasAppSecurityEnabled() {
        try {
            Class<?> clz = Class.forName("com.ibm.websphere.security.WSSecurityHelper");
            if (clz != null) {
                Method method = clz.getDeclaredMethod("isServerSecurityEnabled", null);
                Object obj = clz.newInstance();
                was_securityHelperLoaded = true;
                if (!((Boolean)method.invoke(obj, (Object[])null)).booleanValue()) {
                    logger.trace("Exit from AuthorizationHandler handleRequest: WebSphere Application Security is not enabled");
                    return false;
                }
                logger.trace("AuthorizationHandler handleRequest: WebSphere Application Security is enabled");
                return true;
            }
        }
        catch (Throwable t) {
            logger.trace("Warning: AuthorizationHandler handleRequest failed to load class com.ibm.websphere.security.WSSecurityHelper and caught exception: " + t.getMessage());
        }
        return false;
    }
}

