/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.contexts;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.PathSegmentImpl;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private static final Logger logger = LoggerFactory.getLogger(UriInfoImpl.class);
    private MessageContext messageContext;
    private URI absolutePath;
    private URI baseUri;
    private String baseUriString;
    private String path;
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> decodedPathParameters;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> decodedQueryParameters;
    private List<PathSegment> pathSegments;
    private List<PathSegment> decodedPathSegments;
    private List<String> matchedURIsStrings;
    private List<String> decodedMatchedURIsStrings;

    public UriInfoImpl(MessageContext msgContext) {
        this.messageContext = msgContext;
        this.absolutePath = null;
        this.baseUri = null;
        this.baseUriString = null;
        this.path = null;
        this.pathParameters = null;
        this.pathSegments = null;
        this.decodedPathSegments = null;
        this.matchedURIsStrings = null;
        this.decodedMatchedURIsStrings = null;
    }

    public URI getAbsolutePath() {
        if (this.absolutePath == null) {
            String requestPath = this.getPath(false);
            this.absolutePath = this.getBaseUri().resolve(requestPath);
        }
        logger.trace("getAbsolutePath() returning: {}", (Object)this.absolutePath);
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getAbsolutePath());
        logger.trace("getAbsolutePathBuilder() returning: {}", (Object)builder);
        return builder;
    }

    public URI getBaseUri() {
        block3: {
            if (this.baseUri == null) {
                String baseUriString = this.getBaseUriString();
                try {
                    this.baseUri = new URI(baseUriString);
                }
                catch (URISyntaxException e) {
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error(Messages.getMessage("uriBadBaseURI", baseUriString), (Throwable)e);
                }
            }
        }
        logger.trace("getBaseUri() returning: {}", (Object)this.baseUri);
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getBaseUri());
        logger.trace("getBaseUriBuilder() returning: {}", (Object)builder);
        return builder;
    }

    public List<ResourceInstance> getMatchedResourceInstances() {
        List<ResourceInstance> resources = Collections.unmodifiableList(this.messageContext.getAttribute(SearchResult.class).getData().getMatchedResources());
        logger.trace("getMatchedResourceInstances() returning: {}", resources);
        return resources;
    }

    public List<Object> getMatchedResources() {
        LinkedList<ResourceInstance> matchedResources = this.messageContext.getAttribute(SearchResult.class).getData().getMatchedResources();
        ArrayList<Object> resourceList = new ArrayList<Object>(matchedResources.size());
        for (ResourceInstance resourceInstance : matchedResources) {
            resourceList.add(resourceInstance.getInstance(this.messageContext));
        }
        logger.trace("getMatchedResources() returning: {}", resourceList);
        return Collections.unmodifiableList(resourceList);
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        logger.trace("getMatchedURIs({}) called", (Object)decode);
        LinkedList<List<PathSegment>> matchedURIs = this.messageContext.getAttribute(SearchResult.class).getData().getMatchedURIs();
        if (this.matchedURIsStrings != null && this.matchedURIsStrings.size() != matchedURIs.size()) {
            this.matchedURIsStrings = null;
            this.decodedMatchedURIsStrings = null;
        }
        if (this.matchedURIsStrings == null) {
            this.matchedURIsStrings = new ArrayList<String>(matchedURIs.size());
            for (List list : matchedURIs) {
                logger.trace("Adding matched URI: {}", (Object)list);
                this.matchedURIsStrings.add(PathSegmentImpl.toString(list));
            }
        }
        List<String> list = this.matchedURIsStrings;
        if (decode) {
            if (this.decodedMatchedURIsStrings == null) {
                this.decodedMatchedURIsStrings = new ArrayList<String>(this.matchedURIsStrings.size());
                for (String uri : this.matchedURIsStrings) {
                    String decodedUri = UriEncoder.decodeString(uri);
                    this.decodedMatchedURIsStrings.add(decodedUri);
                    logger.trace("Adding decoded URI: {} from URI: {}", (Object)decodedUri, (Object)uri);
                }
            }
            list = this.decodedMatchedURIsStrings;
        }
        logger.trace("getMatchedURIs({}) returning {}", (Object)decode, list);
        return Collections.unmodifiableList(list);
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        logger.trace("getPath({}) called", (Object)decode);
        if (this.path == null) {
            this.path = UriInfoImpl.buildRequestPath(this.messageContext.getAttribute(HttpServletRequest.class));
        }
        if (decode) {
            String decodedPath = UriEncoder.decodeString(this.path);
            logger.trace("getPath({}) returning {}", (Object)decode, (Object)decodedPath);
            return decodedPath;
        }
        logger.trace("getPath({}) returning {}", (Object)decode, (Object)this.path);
        return this.path;
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        logger.trace("getPathParameters({}) called", (Object)decode);
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl<String, String>();
            SearchResult searchResult = this.messageContext.getAttribute(SearchResult.class);
            if (searchResult == null) {
                throw new IllegalStateException(Messages.getMessage("methodCallOutsideScopeOfRequestContext"));
            }
            MultivaluedMapImpl.copy(searchResult.getData().getMatchedVariables(), this.pathParameters);
            logger.trace("getPathParameters({}) encoded path parameters are: {}", (Object)decode, this.pathParameters);
        }
        MultivaluedMap<String, String> map = this.pathParameters;
        if (decode) {
            if (this.decodedPathParameters == null) {
                this.decodedPathParameters = UriEncoder.decodeMultivaluedMapValues(this.pathParameters);
            }
            map = this.decodedPathParameters;
        }
        logger.trace("getPathParameters({}) returning {}", (Object)decode, map);
        return map;
    }

    public void resetPathParameters() {
        this.pathParameters = null;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        logger.trace("getPathSegments({}) called", (Object)decode);
        if (this.pathSegments == null) {
            this.pathSegments = UriHelper.parsePath(this.getPath(false));
            logger.trace("getPathSegments({}) encoded path parameters are: {}", (Object)decode, this.pathSegments);
        }
        List<PathSegment> list = this.pathSegments;
        if (decode) {
            if (this.decodedPathSegments == null) {
                this.decodedPathSegments = UriHelper.parsePath(this.getPath(true));
            }
            list = this.decodedPathSegments;
        }
        logger.trace("getPathSegments({}) returning {}", (Object)decode, list);
        return list;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        logger.trace("getQueryParameters({}) called", (Object)decode);
        if (this.queryParameters == null) {
            this.queryParameters = new MultivaluedMapImpl<String, String>();
            String query = this.messageContext.getAttribute(HttpServletRequest.class).getQueryString();
            logger.trace("getQueryParameters({}) query string is: {}", (Object)decode, (Object)query);
            this.queryParameters = UriHelper.parseQuery(query);
            logger.trace("getQueryParameters({}) encoded query parameters are: {}", (Object)decode, this.queryParameters);
        }
        MultivaluedMap<String, String> map = this.queryParameters;
        if (decode) {
            if (this.decodedQueryParameters == null) {
                this.decodedQueryParameters = this.queryParameters.size() == 0 ? this.queryParameters : UriEncoder.decodeMultivaluedMapValues(this.queryParameters);
            }
            map = this.decodedQueryParameters;
        }
        logger.trace("getQueryParameters({}) returning {}", (Object)decode, map);
        return map;
    }

    public URI getRequestUri() {
        logger.trace("getRequestUri() called");
        UriBuilder builder = this.getAbsolutePathBuilder();
        String query = this.messageContext.getAttribute(HttpServletRequest.class).getQueryString();
        logger.trace("getRequestUri() query string: {}", (Object)query);
        builder.replaceQuery(query);
        logger.trace("getRequestUri() build after query replacement: {}", (Object)builder);
        URI uri = builder.build(new Object[0]);
        logger.trace("getRequestUri() returning: {}", (Object)uri);
        return uri;
    }

    public UriBuilder getRequestUriBuilder() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getRequestUri());
        logger.trace("getRequestUriBuilder() returning: {}", (Object)builder);
        return builder;
    }

    private String getBaseUriString() {
        if (this.baseUriString == null) {
            this.baseUriString = this.buildBaseUriString(this.messageContext.getAttribute(HttpServletRequest.class), this.messageContext.getProperties());
        }
        logger.trace("getBaseUriString() returned {}", (Object)this.baseUriString);
        return this.baseUriString;
    }

    private String buildBaseUriString(HttpServletRequest request, Properties properties) {
        String httpURI = this.getURI(properties, "wink.http.uri");
        String httpsURI = this.getURI(properties, "wink.https.uri");
        if (httpURI != null || httpsURI != null) {
            if (httpsURI == null) {
                throw new IllegalStateException(Messages.getMessage("parameterHttpsIsEmptyOrNotInitialized"));
            }
            if (httpURI == null) {
                throw new IllegalStateException(Messages.getMessage("parameterHttpIsEmptyOrNotInitialized"));
            }
        } else {
            logger.trace("Endpoint is not set up in the configuration; using request detection");
        }
        String baseURI = httpURI;
        if (request.isSecure()) {
            logger.trace("buildBaseUriString request is secure");
            baseURI = httpsURI;
        }
        logger.trace("buildBaseUriString baseURI from properties is: {}", (Object)baseURI);
        if (baseURI == null) {
            baseURI = UriInfoImpl.autodetectBaseUri(request);
            logger.trace("buildBaseUriString baseURI from autodetectBaseUri is: {}", (Object)baseURI);
        }
        return this.appendContextAndServletPath(baseURI, request, properties);
    }

    private String getURI(Properties properties, String propertyName) {
        String uri = properties.getProperty(propertyName);
        logger.trace("getURI({}, {}) called", (Object)properties, (Object)propertyName);
        if (uri != null && uri.length() != 0) {
            try {
                URI uriParsed = new URI(uri);
                logger.trace("getURI({}, {}) returning {}", new Object[]{properties, propertyName, uriParsed});
                return uriParsed.toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(Messages.getMessage("uriInfoInvalidURI"), e);
            }
        }
        logger.trace("getURI({}, {}) returning null", (Object)properties, (Object)propertyName);
        return null;
    }

    private static String autodetectBaseUri(HttpServletRequest request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), "/", null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private String appendContextAndServletPath(String basePath, HttpServletRequest request, Properties properties) {
        String contextURI;
        String contextPath;
        logger.trace("appendContextAndServletPath({}, {}, {}) called", new Object[]{basePath, request, properties});
        StringBuilder builder = new StringBuilder(basePath);
        if (builder.charAt(builder.length() - 1) == '/') {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = contextPath = (contextURI = properties.getProperty("wink.context.uri")) != null && contextURI.length() > 0 ? contextURI : request.getContextPath();
        if (contextPath != null) {
            builder.append(contextPath);
            logger.trace("appendContextAndServletPath after contextPath called is: {} ", (Object)builder);
        }
        boolean isServlet = RuntimeContextTLS.getRuntimeContext().getAttribute(FilterConfig.class) == null;
        logger.trace("appendContextAndServletPath isServlet: {} ", (Object)isServlet);
        if (request.getServletPath() != null && isServlet) {
            builder.append(request.getServletPath());
            logger.trace("appendContextAndServletPath after getServletPath called is: {} ", (Object)builder);
        }
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        String builderStr = builder.toString();
        logger.trace("appendContextAndServletPath returning: {} ", (Object)builderStr);
        return builderStr;
    }

    private static String buildRequestPath(HttpServletRequest request) {
        int index;
        String requestPath = request.getRequestURI();
        logger.trace("buildRequestPath requestPath is: {}", (Object)requestPath);
        requestPath = UriHelper.normalize(requestPath);
        logger.trace("buildRequestPath requestPath normalized is: {}", (Object)requestPath);
        if (request.getContextPath() != null) {
            requestPath = requestPath.substring(request.getContextPath().length());
            logger.trace("buildRequestPath after context path removed: {}", (Object)requestPath);
        }
        boolean isServlet = RuntimeContextTLS.getRuntimeContext().getAttribute(FilterConfig.class) == null;
        logger.trace("buildRequestPath isServlet: {}", (Object)isServlet);
        if (request.getServletPath() != null && isServlet) {
            requestPath = requestPath.substring(request.getServletPath().length());
            logger.trace("buildRequestPath requestPath after servlet path removed: {}", (Object)requestPath);
        }
        for (index = 0; index < requestPath.length() && requestPath.charAt(index) == '/'; ++index) {
        }
        requestPath = requestPath.substring(index);
        logger.trace("buildRequestPath returning requestPath: {}", (Object)requestPath);
        return requestPath;
    }
}

