/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.contexts;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.WinkConfiguration;
import org.apache.wink.common.internal.contexts.MediaTypeCharsetAdjuster;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMediaTypeCharsetAdjuster
implements MediaTypeCharsetAdjuster {
    private static final ServerMediaTypeCharsetAdjuster instance = new ServerMediaTypeCharsetAdjuster();
    private static final Logger logger = LoggerFactory.getLogger(ServerMediaTypeCharsetAdjuster.class);

    private ServerMediaTypeCharsetAdjuster() {
    }

    public static ServerMediaTypeCharsetAdjuster getInstance() {
        return instance;
    }

    @Override
    public MediaType setDefaultCharsetOnMediaTypeHeader(MultivaluedMap<String, Object> httpHeaders, MediaType mediaType) {
        logger.trace("setDefaultCharsetOnMediaTypeHeader({}, {}) entry", httpHeaders, (Object)mediaType);
        RuntimeContext context = RuntimeContextTLS.getRuntimeContext();
        DeploymentConfiguration config = (DeploymentConfiguration)context.getAttribute(WinkConfiguration.class);
        if (config.isDefaultResponseCharset() || config.isUseAcceptCharset()) {
            if (httpHeaders != null && (httpHeaders.isEmpty() || httpHeaders.get((Object)"Content-Type") == null)) {
                logger.trace("Media Type not explicitly set on Response so going to correct charset parameter if necessary");
                if (ProviderUtils.getCharsetOrNull(mediaType) == null) {
                    try {
                        String charsetValue = "UTF-8";
                        if (config.isUseAcceptCharset()) {
                            HttpHeaders requestHeaders = null;
                            if (context != null) {
                                requestHeaders = context.getHttpHeaders();
                            }
                            charsetValue = ProviderUtils.getCharset(mediaType, requestHeaders);
                        }
                        String newMediaTypeStr = mediaType.toString() + ";charset=" + charsetValue;
                        mediaType = MediaType.valueOf((String)newMediaTypeStr);
                        httpHeaders.putSingle((Object)"Content-Type", (Object)newMediaTypeStr);
                        logger.trace("Changed media type to be {} in Content-Type HttpHeader", (Object)newMediaTypeStr);
                    }
                    catch (Exception e) {
                        logger.trace("Caught exception while trying to set the charset", (Throwable)e);
                    }
                }
            }
        } else {
            logger.trace("No default charset was applied to the response Content-Type header due to deployment configuration directive.");
        }
        logger.trace("setDefaultCharsetOnMediaTypeHeader() exit returning {}", (Object)mediaType);
        return mediaType;
    }
}

