/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.application.ApplicationExceptionAttribute;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.application.ServletApplicationFileLoader;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.handlers.ServerMessageContext;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.resources.HtmlServiceDocumentResource;
import org.apache.wink.server.internal.resources.RootResource;
import org.apache.wink.server.utils.RegistrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RequestProcessor.class);
    private static final String PROPERTY_ROOT_RESOURCE_NONE = "none";
    private static final String PROPERTY_ROOT_RESOURCE_ATOM = "atom";
    private static final String PROPERTY_ROOT_RESOURCE_ATOM_HTML = "atom+html";
    private static final String PROPERTY_ROOT_RESOURCE_DEFAULT = "atom+html";
    private static final String PROPERTY_ROOT_RESOURCE = "wink.rootResource";
    private static final String PROPERTY_ROOT_RESOURCE_CSS = "wink.serviceDocumentCssPath";
    private static final String PROPERTY_LOAD_WINK_APPLICATIONS = "wink.loadApplications";
    private boolean alreadyLogged = false;
    private final DeploymentConfiguration configuration;

    public RequestProcessor(DeploymentConfiguration configuration) {
        this.configuration = configuration;
        this.registerDefaultApplication();
        this.registerRootResources();
    }

    private void registerDefaultApplication() {
        try {
            String loadWinkApplicationsProperty = this.configuration.getProperties().getProperty(PROPERTY_LOAD_WINK_APPLICATIONS, Boolean.toString(true));
            logger.trace("{} property is set to: {}", (Object)PROPERTY_LOAD_WINK_APPLICATIONS, (Object)loadWinkApplicationsProperty);
            Set<Class<?>> classes = new ServletApplicationFileLoader(Boolean.parseBoolean(loadWinkApplicationsProperty)).getClasses();
            RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(classes);
            application.setPriority(0.1);
            this.configuration.addApplication(application, true);
        }
        catch (FileNotFoundException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private void registerRootResources() {
        Properties properties = this.configuration.getProperties();
        String registerRootResource = properties.getProperty(PROPERTY_ROOT_RESOURCE, "atom+html");
        logger.trace("{} property is set to: {}", (Object)PROPERTY_ROOT_RESOURCE, (Object)registerRootResource);
        if (registerRootResource.equals(PROPERTY_ROOT_RESOURCE_ATOM)) {
            RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(RootResource.class);
            application.setPriority(0.1);
            this.configuration.addApplication(application, true);
        } else if (!registerRootResource.equals(PROPERTY_ROOT_RESOURCE_NONE)) {
            String css = properties.getProperty(PROPERTY_ROOT_RESOURCE_CSS);
            logger.trace("{} property is set to: {}", (Object)PROPERTY_ROOT_RESOURCE_CSS, (Object)css);
            HtmlServiceDocumentResource instance = new HtmlServiceDocumentResource();
            if (css != null) {
                instance.setServiceDocumentCssPath(css);
            }
            RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(instance);
            application.setPriority(0.1);
            this.configuration.addApplication(application, true);
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (logger.isDebugEnabled()) {
                String requestMethod = request.getMethod();
                String requestString = request.getRequestURL().toString();
                requestString = requestString + (request.getQueryString() != null && request.getQueryString().length() > 0 ? "?" + request.getQueryString() : "");
                logger.debug(Messages.getMessage("processingRequestTo", requestMethod, requestString, request.getContentType(), request.getHeader("Accept")));
            }
            this.handleRequestWithoutFaultBarrier(request, response);
        }
        catch (Throwable t) {
            ApplicationExceptionAttribute appEx = null;
            RuntimeContext runtimeContext = RuntimeContextTLS.getRuntimeContext();
            if (runtimeContext != null) {
                appEx = runtimeContext.getAttribute(ApplicationExceptionAttribute.class);
            }
            if (appEx != null && appEx.getDebugMsg() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(appEx.getDebugMsg());
                }
                this.alreadyLogged = true;
            } else if (logger.isTraceEnabled()) {
                if (this.alreadyLogged) {
                    logger.trace(Messages.getMessage("unhandledExceptionToContainer"));
                } else {
                    logger.trace(Messages.getMessage("unhandledExceptionToContainer"), t);
                }
            } else if (logger.isErrorEnabled()) {
                if (this.alreadyLogged) {
                    logger.error(Messages.getMessage("unhandledExceptionToContainer"));
                } else {
                    logger.error(Messages.getMessage("unhandledExceptionToContainer"), t);
                }
            }
            this.alreadyLogged = false;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ServletException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestWithoutFaultBarrier(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        boolean isReleaseResourcesCalled = false;
        try {
            ServerMessageContext msgContext = this.createMessageContext(request, response);
            RuntimeContextTLS.setRuntimeContext(msgContext);
            logger.trace("Set message context and starting request handlers chain: {}", (Object)msgContext);
            this.configuration.getRequestHandlersChain().run(msgContext);
            logger.trace("Finished request handlers chain and starting response handlers chain: {}", (Object)msgContext);
            this.configuration.getResponseHandlersChain().run(msgContext);
            logger.trace("Attempting to release resource instance");
            isReleaseResourcesCalled = true;
            try {
                this.releaseResources(msgContext);
            }
            catch (Exception e) {
                logger.trace("Caught exception when releasing resource object", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable t) {
            RuntimeContext originalContext = RuntimeContextTLS.getRuntimeContext();
            ServerMessageContext msgContext = null;
            try {
                this.logException(t, request);
                msgContext = this.createMessageContext(request, response);
                RuntimeContextTLS.setRuntimeContext(msgContext);
                msgContext.setResponseEntity(t);
                logger.trace("Exception occured, starting error handlers chain: {}", (Object)msgContext);
                this.configuration.getErrorHandlersChain().run(msgContext);
                RuntimeContextTLS.setRuntimeContext(originalContext);
                if (!isReleaseResourcesCalled) {
                    isReleaseResourcesCalled = true;
                    try {
                        this.releaseResources(originalContext);
                    }
                    catch (Exception e2) {
                        logger.trace("Caught exception when releasing resource object", (Throwable)e2);
                    }
                }
            }
            catch (Exception e) {
                RuntimeContextTLS.setRuntimeContext(originalContext);
                if (!isReleaseResourcesCalled) {
                    isReleaseResourcesCalled = true;
                    try {
                        this.releaseResources(originalContext);
                    }
                    catch (Exception e2) {
                        logger.trace("Caught exception when releasing resource object", (Throwable)e2);
                    }
                }
                throw e;
            }
        }
        finally {
            logger.trace("Finished response handlers chain");
            RuntimeContextTLS.setRuntimeContext(null);
        }
    }

    private void releaseResources(RuntimeContext msgContext) throws Exception {
        SearchResult searchResult = msgContext.getAttribute(SearchResult.class);
        if (searchResult != null) {
            LinkedList<ResourceInstance> resourceInstances = searchResult.getData().getMatchedResources();
            for (ResourceInstance res : resourceInstances) {
                logger.trace("Releasing resource instance");
                res.releaseInstance(msgContext);
            }
        }
    }

    private void logException(Throwable t, HttpServletRequest request) {
        String messageFormat;
        ApplicationExceptionAttribute appEx = RuntimeContextTLS.getRuntimeContext().getAttribute(ApplicationExceptionAttribute.class);
        if (appEx != null && appEx.getDebugMsg() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(appEx.getDebugMsg());
            }
            this.alreadyLogged = true;
            return;
        }
        String requestMethod = request.getMethod();
        String requestString = request.getRequestURL().toString();
        requestString = requestString + (request.getQueryString() != null && request.getQueryString().length() > 0 ? "?" + request.getQueryString() : "");
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            int statusCode = wae.getResponse().getStatus();
            Response.Status status = Response.Status.fromStatusCode((int)statusCode);
            String statusSep = "";
            String statusMessage = "";
            if (status != null) {
                statusSep = " - ";
                statusMessage = status.toString();
            }
            String exceptionName = String.format("%s (%d%s%s)", t.getClass().getSimpleName(), statusCode, statusSep, statusMessage);
            messageFormat = Messages.getMessage("exceptionOccurredDuringInvocation", exceptionName, wae.getMessage(), requestMethod, requestString);
        } else {
            messageFormat = Messages.getMessage("exceptionOccurredDuringInvocation", t.getClass().getSimpleName(), t.getMessage(), requestMethod, requestString);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(messageFormat, t);
            ResourceRegistry rr = this.configuration.getResourceRegistry();
            List<ResourceRecord> resourceRecords = rr.getRecords();
            StringBuffer sb = new StringBuffer();
            String newLine = System.getProperty("line.separator");
            for (ResourceRecord record : resourceRecords) {
                sb.append(newLine + "  " + record.toString());
            }
            logger.debug(Messages.getMessage("registeredResources", sb.toString().length() > 0 ? sb.toString() : "{}"));
            logger.debug(this.configuration.getProvidersRegistry().getLogFormattedProvidersList(true));
        }
    }

    private ServerMessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response) {
        ServerMessageContext messageContext = new ServerMessageContext(request, response, this.configuration);
        return messageContext;
    }

    public DeploymentConfiguration getConfiguration() {
        return this.configuration;
    }

    public static RequestProcessor getRequestProcessor(ServletContext servletContext, String attributeName) {
        if (attributeName == null) {
            attributeName = RequestProcessor.class.getName();
        }
        RequestProcessor requestProcessor = (RequestProcessor)servletContext.getAttribute(attributeName);
        logger.trace("Retrieving request processor {} using attribute name {} in servlet context {}", new Object[]{requestProcessor, attributeName, servletContext});
        return requestProcessor;
    }

    public void storeRequestProcessorOnServletContext(ServletContext servletContext, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            attributeName = RequestProcessor.class.getName();
        }
        logger.trace("Storing request processor {} using attribute name {} in servlet context {}", new Object[]{this, attributeName, servletContext});
        servletContext.setAttribute(attributeName, (Object)this);
    }
}

