/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.wadl;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.wink.common.model.wadl.Application;
import org.apache.wink.common.model.wadl.WADLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WADLAntTask
extends Task {
    private String applicationClassName;
    private String destFile;
    private AntClassLoader antTaskClassLoader = null;
    private Path classpath = null;
    private String baseUri = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.applicationClassName == null) {
            throw new BuildException("applicationClass attribute not set.");
        }
        if (this.destFile == null) {
            throw new BuildException("destFile attribute not set.");
        }
        try {
            if (this.classpath != null) {
                this.antTaskClassLoader = this.getProject().createClassLoader(this.classpath);
                this.antTaskClassLoader.setParent(((Object)((Object)this)).getClass().getClassLoader());
                this.antTaskClassLoader.setThreadContextLoader();
            }
            HashSet classes = new HashSet();
            try {
                Set singletons;
                javax.ws.rs.core.Application app = (javax.ws.rs.core.Application)this.loadClass(this.applicationClassName).newInstance();
                Set clses = app.getClasses();
                if (clses != null) {
                    classes.addAll(app.getClasses());
                }
                if ((singletons = app.getSingletons()) != null) {
                    for (Object obj : singletons) {
                        classes.add(obj.getClass());
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new BuildException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new BuildException((Throwable)e);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            Application wadlApp = new WADLGenerator().generate(this.baseUri, classes);
            try {
                Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{Application.class}).createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)wadlApp, new File(this.destFile));
            }
            catch (JAXBException e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (this.antTaskClassLoader != null) {
                this.antTaskClassLoader.resetThreadContextLoader();
                this.antTaskClassLoader.cleanup();
                this.antTaskClassLoader = null;
            }
        }
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClassName = applicationClass;
    }

    public void setDestFile(String destFile) {
        this.destFile = destFile;
    }

    private Class<?> loadClass(String className) throws Exception {
        if (this.antTaskClassLoader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, (ClassLoader)this.antTaskClassLoader);
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference refId) {
        this.createClasspath().setRefid(refId);
    }
}

