/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.opensearch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.wink.common.model.opensearch.OpenSearchParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="OpenSearchUrl")
public class OpenSearchUrl {
    protected String type;
    protected String template;
    @XmlTransient
    private List<OpenSearchParameter> openSearchParameters;
    @XmlTransient
    private static final String paramDelimiter = "&";
    @XmlTransient
    private static final String searchDelimiter = "?";
    @XmlTransient
    private String baseUri;

    @XmlAttribute
    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    @XmlAttribute
    public String getTemplate() {
        if (this.template != null) {
            return this.template;
        }
        return this.generateOpenSearchUrlTemplate();
    }

    public void setTemplate(String value) {
        this.template = value;
    }

    public void addOpenSearchParameter(OpenSearchParameter openSearchParameter) {
        this.getOpenSearchParameters().add(openSearchParameter);
    }

    public List<OpenSearchParameter> getOpenSearchParameters() {
        if (this.openSearchParameters == null) {
            this.openSearchParameters = new ArrayList<OpenSearchParameter>();
        }
        return this.openSearchParameters;
    }

    public String generateOpenSearchUrlTemplate() {
        String paramList = searchDelimiter;
        if (this.openSearchParameters == null) {
            return "";
        }
        Iterator<OpenSearchParameter> itr = this.openSearchParameters.iterator();
        if (!itr.hasNext()) {
            return "";
        }
        OpenSearchParameter openSearchParameter = itr.next();
        paramList = paramList + openSearchParameter.getURLParameter();
        while (itr.hasNext()) {
            paramList = paramList + paramDelimiter;
            openSearchParameter = itr.next();
            paramList = paramList + openSearchParameter.getURLParameter();
        }
        this.template = this.baseUri + paramList;
        return this.template;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }
}

