/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.multipart;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPart {
    private MultivaluedMap<String, String> headers = new CaseInsensitiveMultivaluedMap<String>();
    private InputStream inputStream;
    private Providers providers;
    private String encoding;
    public static final String BASE64_ENCODING = "base64";
    public static final String QUOTED_PRINTABLE_ENCODING = "quoted-printable";

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public InPart() {
    }

    public InPart(MultivaluedMap<String, String> headers, Providers providers) {
        this.headers = headers;
        this.providers = providers;
    }

    protected void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        String res = (String)this.getHeaders().getFirst((Object)"Content-Type");
        if (res == null) {
            res = "text/plain";
        }
        return res;
    }

    public String getPartName() {
        MediaType mt;
        String name;
        String res = (String)this.getHeaders().getFirst((Object)"Content-Disposition");
        if (res != null && (name = (String)(mt = MediaType.valueOf((String)("Content-Type: text/plain; " + res))).getParameters().get("name")) != null) {
            return name.substring(name.indexOf(34) + 1, name.lastIndexOf(34));
        }
        return null;
    }

    public Set<String> getHeadersName() {
        return this.getHeaders().keySet();
    }

    public <T> T getBody(Class<T> type, Type genericType, Providers providers) throws IOException {
        MediaType mt = MediaType.valueOf((String)this.getContentType());
        MessageBodyReader reader = providers.getMessageBodyReader(type, genericType, null, mt);
        if (reader == null) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        Object is = BASE64_ENCODING.equals(this.encoding) ? new Base64InputStream(this.getInputStream()) : (QUOTED_PRINTABLE_ENCODING.equals(this.encoding) ? new QuotedPrintableInputStream(this.getInputStream()) : this.getInputStream());
        return (T)reader.readFrom(type, genericType, null, mt, this.getHeaders(), (InputStream)is);
    }

    public <T> T getBody(Class<T> type, Type genericType) throws IOException {
        return this.getBody(type, genericType, this.providers);
    }

    private class QuotedPrintableDecoder {
        private ByteArrayOutputStream buffer;
        private int omittedCount;

        private QuotedPrintableDecoder() {
        }

        public void decode(byte[] bytes, int off, int len) throws DecoderException {
            this.buffer = new ByteArrayOutputStream();
            this.omittedCount = 0;
            for (int i = off; i < len; ++i) {
                byte b = bytes[i];
                if (b == 61) {
                    try {
                        int u = this.digit16(bytes[++i]);
                        int l = this.digit16(bytes[++i]);
                        this.buffer.write((char)((u << 4) + l));
                        this.omittedCount += 2;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new DecoderException("Invalid quoted-printable encoding", (Throwable)e);
                    }
                }
                this.buffer.write(b);
            }
        }

        public byte[] getBytes() {
            return this.buffer.toByteArray();
        }

        public int getOmmittedCount() {
            return this.omittedCount;
        }

        private int digit16(byte b) throws DecoderException {
            int i = Character.digit((char)b, 16);
            if (i == -1) {
                throw new DecoderException("Invalid URL encoding: not a valid digit (radix 16): " + b);
            }
            return i;
        }
    }

    private class QuotedPrintableInputStream
    extends FilterInputStream {
        private QuotedPrintableDecoder decoder;
        private final byte[] singleByte;

        public QuotedPrintableInputStream(InputStream is) {
            super(is);
            this.singleByte = new byte[1];
            this.decoder = new QuotedPrintableDecoder();
        }

        public int read() throws IOException {
            int r = this.read(this.singleByte, 0, 1);
            while (r == 0) {
                r = this.read(this.singleByte, 0, 1);
            }
            if (r > 0) {
                return this.singleByte[0] < 0 ? 256 + this.singleByte[0] : this.singleByte[0];
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (off > b.length || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int read = this.in.read(b, off, len);
            if (read != -1) {
                try {
                    this.decoder.decode(b, off, read);
                }
                catch (DecoderException e) {
                    throw new IOException(e.getMessage());
                }
                System.arraycopy(this.decoder.getBytes(), 0, b, 0, read - this.decoder.getOmmittedCount());
                return read - this.decoder.getOmmittedCount();
            }
            return -1;
        }
    }
}

