/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.uritemplate;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.uritemplate.JaxRsUriTemplateProcessor;
import org.apache.wink.common.internal.uritemplate.UriTemplateMatcher;
import org.apache.wink.common.internal.utils.UriHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UriTemplateProcessor
implements Comparable<UriTemplateProcessor>,
Cloneable {
    protected static final String TEMPLATE_TAIL_NAME = "wink.TemplateTail";
    protected static final String TEMPLATE_HEAD_NAME = "wink.TemplateHead";
    protected static final String TEMPLATE_TAIL_PATTERN = "(/.*)?";
    protected String template = null;
    protected Pattern pattern = null;
    protected MultivaluedMap<String, CapturingGroup> variables = new MultivaluedMapImpl<String, CapturingGroup>();
    protected List<TemplateElement> expanders = new ArrayList<TemplateElement>();
    protected int numOfLiteralCharacters = 0;
    protected CapturingGroup head = null;
    protected CapturingGroup tail = null;

    protected UriTemplateProcessor() {
    }

    protected void reset() {
        this.variables.clear();
        this.expanders.clear();
        this.pattern = null;
        this.tail = null;
        this.head = null;
        this.numOfLiteralCharacters = 0;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getPatternString() {
        this.assertPatternState();
        return this.pattern.pattern();
    }

    Pattern getPattern() {
        return this.pattern;
    }

    MultivaluedMap<String, CapturingGroup> getVariables() {
        return this.variables;
    }

    public Set<String> getVariableNames() throws IllegalStateException {
        this.assertPatternState();
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.variables.keySet());
        return set;
    }

    public UriTemplateMatcher matcher() {
        this.assertPatternState();
        return new UriTemplateMatcher(this);
    }

    public abstract void compile(String var1);

    public String expand(Map<String, ? extends Object> values) {
        return this.expand(values, true);
    }

    public String expand(Map<String, ? extends Object> values, boolean encode) {
        MultivaluedMap<String, String> mValues = MultivaluedMapImpl.toMultivaluedMapString(values);
        return this.expand(mValues, encode);
    }

    public String expand(MultivaluedMap<String, String> values) {
        return this.expand(values, true);
    }

    public String expand(MultivaluedMap<String, String> values, boolean encode) {
        if (values == null) {
            values = new MultivaluedMapImpl<String, String>();
        }
        this.assertPatternState();
        StringBuilder result = new StringBuilder();
        for (TemplateElement expander : this.expanders) {
            expander.expand(values, encode, result);
        }
        String resultStr = result.toString();
        return resultStr;
    }

    public String toString() {
        return this.template;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriTemplateProcessor other = (UriTemplateProcessor)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }

    public UriTemplateProcessor clone() {
        try {
            UriTemplateProcessor ret = (UriTemplateProcessor)super.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR.getCode());
        }
    }

    @Override
    public int compareTo(UriTemplateProcessor other) {
        int ret = this.compareLiteralCharacters(other);
        if (ret != 0) {
            return ret;
        }
        return this.compareNumOfVariables(other);
    }

    private int compareNumOfVariables(UriTemplateProcessor other) {
        return this.variables.size() - other.variables.size();
    }

    private int compareLiteralCharacters(UriTemplateProcessor other) {
        return this.numOfLiteralCharacters - other.numOfLiteralCharacters;
    }

    protected void assertPatternState() {
        if (this.pattern == null) {
            throw new IllegalStateException(Messages.getMessage("patternNotCompiled"));
        }
    }

    public static String normalizeUri(String uri) {
        String normalizedUri = uri != null ? UriHelper.normalize(uri) : "";
        if (normalizedUri.startsWith("/")) {
            normalizedUri = normalizedUri.substring(1);
        }
        return normalizedUri;
    }

    public static UriTemplateProcessor newNormalizedInstance(String uriTemplate) {
        return JaxRsUriTemplateProcessor.newNormalizedInstance(uriTemplate);
    }

    public static boolean match(String template, String path) {
        UriTemplateProcessor processor = UriTemplateProcessor.newNormalizedInstance(template);
        UriTemplateMatcher matcher = processor.matcher();
        return matcher.matches(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractTemplateExpander
    implements BaseCompilationHandler {
        protected MultivaluedMap<String, String> values;
        protected StringBuilder out;

        public AbstractTemplateExpander(MultivaluedMap<String, String> values, StringBuilder out) {
            this.values = values;
            this.out = out;
        }

        @Override
        public void startCompile(String template) {
            if (this.values == null) {
                this.values = new MultivaluedMapImpl<String, String>();
            }
        }

        @Override
        public void literal(String literal) {
            this.out.append(literal);
        }

        @Override
        public void endCompile(String literal) {
            this.literal(literal);
        }
    }

    protected static abstract class AbstractPatternBuilder
    implements BaseCompilationHandler {
        protected UriTemplateProcessor processor;
        protected StringBuilder patternBuilder;
        protected int capturingGroupId;

        protected AbstractPatternBuilder(UriTemplateProcessor processor) {
            this.processor = processor;
        }

        public void startCompile(String template) {
            this.processor.template = template;
            this.processor.reset();
            this.patternBuilder = new StringBuilder(template.length());
            this.capturingGroupId = 0;
            this.openHead();
        }

        public void literal(String literal) {
            int length = literal.length();
            if (length == 0) {
                return;
            }
            Literal element = new Literal(literal);
            element.build(this.patternBuilder);
            this.processor.expanders.add(element);
            this.processor.numOfLiteralCharacters += length;
        }

        public void endCompile(String literal) {
            this.literal(this.removeTrailingSlash(literal));
            this.closeHead();
            this.createTail();
            String templatePatternStr = this.patternBuilder.toString();
            this.processor.pattern = Pattern.compile(templatePatternStr);
        }

        protected String removeTrailingSlash(String literal) {
            if (literal.length() > 0 && literal.charAt(literal.length() - 1) == '/') {
                literal = literal.substring(0, literal.length() - 1);
            }
            return literal;
        }

        protected void openHead() {
            this.patternBuilder.append('(');
            this.processor.head = new Variable(UriTemplateProcessor.TEMPLATE_HEAD_NAME, null, null);
            ++this.capturingGroupId;
            this.processor.head.setCapturingGroupId(this.capturingGroupId);
        }

        protected void closeHead() {
            this.patternBuilder.append(')');
        }

        protected void createTail() {
            this.processor.tail = this.createVariable(UriTemplateProcessor.TEMPLATE_TAIL_NAME, UriTemplateProcessor.TEMPLATE_TAIL_PATTERN, null);
        }

        protected CapturingGroup createVariable(String name, String regex, String defaultValue) {
            Variable variable = new Variable(name, regex, defaultValue);
            variable.build(this.patternBuilder);
            ++this.capturingGroupId;
            variable.setCapturingGroupId(this.capturingGroupId);
            return variable;
        }
    }

    protected static interface BaseCompilationHandler {
        public void startCompile(String var1);

        public void literal(String var1);

        public void endCompile(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Variable
    extends CapturingGroup {
        protected String name;
        protected String regex;
        protected String defaultValue;

        public Variable(String name, String regex, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.regex = regex == null ? "[^/]+?" : regex;
        }

        public String getName() {
            return this.name;
        }

        public String getRegex() {
            return this.regex;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void build(StringBuilder builder) {
            this.regex = this.convertAllGroupsToNonCapturing(this.regex);
            builder.append("(");
            builder.append(this.regex);
            builder.append(")");
        }

        @Override
        public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
            values.add((Object)this.name, (Object)matched);
            indices.add((Object)this.name, (Object)startIndex);
        }

        @Override
        public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
            String value = (String)values.getFirst((Object)this.name);
            if (value == null) {
                value = this.defaultValue;
            }
            if (value == null) {
                throw new IllegalArgumentException(Messages.getMessage("syntaxErrorInvalidTemplateForm", this.name));
            }
            if (encode) {
                value = UriEncoder.encodeString(value);
            }
            builder.append(value);
        }

        private String convertAllGroupsToNonCapturing(String regex) {
            StringBuffer sb = new StringBuffer();
            int regexLen = regex.length();
            for (int i = 0; i < regexLen; ++i) {
                char ch = regex.charAt(i);
                sb.append(ch);
                if (ch != '(' || i + 1 >= regexLen || regex.charAt(i + 1) == '?') continue;
                sb.append("?:");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class CapturingGroup
    implements TemplateElement {
        protected static final String REGEX0 = "[^/]*?";
        protected static final String REGEX1 = "[^/]+?";
        protected int capturingGroupId = -1;

        protected CapturingGroup() {
        }

        public int getCapturingGroupId() {
            return this.capturingGroupId;
        }

        public void setCapturingGroupId(int capturingGroupId) {
            this.capturingGroupId = capturingGroupId;
        }

        public abstract void onMatch(String var1, MultivaluedMap<String, String> var2, int var3, MultivaluedMap<String, Integer> var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Literal
    implements TemplateElement {
        private String literal;

        public Literal(String literal) {
            Literal.assertValid(literal);
            this.literal = literal;
        }

        @Override
        public void build(StringBuilder builder) {
            builder.append(Pattern.quote(this.literal));
        }

        private static void assertValid(String literal) {
            if (literal.indexOf(123) != -1 || literal.indexOf(125) != -1) {
                throw new IllegalArgumentException(Messages.getMessage("variableNotSuppliedAValue", literal));
            }
        }

        @Override
        public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
            String literal = this.literal;
            if (!encode) {
                literal = UriEncoder.decodeString(literal);
            }
            builder.append(literal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TemplateElement {
        public void build(StringBuilder var1);

        public void expand(MultivaluedMap<String, String> var1, boolean var2, StringBuilder var3);
    }
}

