/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.log;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogUtils {
    public static String exceptionToDebugString(Throwable e) {
        String text = e.getClass().getName() + ": " + e.getMessage() + System.getProperty("line.separator");
        text = text + LogUtils.stackToDebugString(e);
        return text;
    }

    public static String stackToDebugString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = "\t" + text.substring(text.indexOf("at "));
        int entryIndex = text.indexOf("at org.apache.wink.server.internal.servlet");
        int endOfEntryLineIndex = text.indexOf(System.getProperty("line.separator"), entryIndex);
        text = text.substring(0, endOfEntryLineIndex);
        text = LogUtils.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }

    private static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String(sb);
    }
}

