/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.application;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.common.internal.utils.ClassUtils;
import org.apache.wink.common.internal.utils.FileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationFileLoader {
    private static final String WINK_APPLICATION = "META-INF/wink-application";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationFileLoader.class);
    private static final String CORE_APPLICATION = "META-INF/core/wink-providers";
    private final Set<Class<?>> classes = new LinkedHashSet();

    public ApplicationFileLoader(boolean loadWinkApplication) throws FileNotFoundException {
        this(CORE_APPLICATION);
        try {
            if (loadWinkApplication) {
                Enumeration<URL> applications = FileLoader.loadFileUsingClassLoaders(WINK_APPLICATION);
                while (applications.hasMoreElements()) {
                    URL url = applications.nextElement();
                    if (logger.isDebugEnabled()) {
                        logger.debug(Messages.getMessage("loadingApplication", url.toExternalForm()));
                    }
                    this.loadClasses(url.openStream());
                }
            }
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public ApplicationFileLoader(String appConfigFile) throws FileNotFoundException {
        if (logger.isTraceEnabled()) {
            logger.trace(Messages.getMessage("loadingApplication", appConfigFile));
        }
        this.loadClasses(FileLoader.loadFileAsStream(appConfigFile));
    }

    public ApplicationFileLoader(InputStream appConfigFileStream) throws FileNotFoundException {
        this.loadClasses(appConfigFileStream);
    }

    protected final void loadClasses(InputStream is) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                Class cls = null;
                try {
                    cls = ClassUtils.loadClass(line);
                    if (ResourceMetadataCollector.isStaticResource(cls) || ProviderMetadataCollector.isProvider(cls)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace(Messages.getMessage("loadingClassToApplication", line));
                        }
                        this.classes.add(cls);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(Messages.getMessage("classNotAResourceNorProvider", cls.getName()));
                }
                catch (ClassNotFoundException e) {
                    if (!line.contains("com.ibm.websphere.jaxrs.providers.json4j") && !line.contains("org.apache.wink.providers.jackson.WinkJacksonJaxbJsonProvider") && logger.isErrorEnabled()) {
                        logger.error(Messages.getMessage("isNotAClassWithMsgFormat", line), (Throwable)e);
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("ClassNotFoundException while loading class", (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error(Messages.getMessage("classInstantiationExceptionWithMsgFormat", line), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            block17: {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!logger.isInfoEnabled()) break block17;
                    logger.info(Messages.getMessage("exceptionClosingFile"), (Throwable)e);
                }
            }
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }
}

