/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responses
implements ClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(Responses.class);
    public static final int BREAK_POINT = Integer.valueOf(System.getProperty(Responses.class.getName() + ".breakPoint", "4096"));
    public static final boolean IS_LOGGED_AS_BYTES = Boolean.valueOf(System.getProperty(Responses.class.getName() + ".logAsBytes", "false"));
    public static final int BUFFER_SIZE = Integer.valueOf(System.getProperty(Responses.class.getName() + ".bufferSize", "8192"));

    public static void log(LoggedInputStream loggedIS) {
        if (loggedIS == null || loggedIS.getLoggedByteBufferLength() == 0) {
            logger.debug("The response entity was not read from the input stream adapter.");
            return;
        }
        byte[] buffer = loggedIS.getLoggedByteBuffer();
        int bufferLength = loggedIS.getLoggedByteBufferLength();
        if (IS_LOGGED_AS_BYTES) {
            logger.debug("The response entity as bytes:");
            StringBuffer sb = new StringBuffer();
            int outputCount = 0;
            for (int count = 0; count < bufferLength; ++count) {
                sb.append(String.format("%#04x ", buffer[count]));
                sb.append(" ");
                if (++outputCount <= BREAK_POINT) continue;
                logger.debug("{}", (Object)sb);
                sb = new StringBuffer();
                outputCount = 0;
            }
            if (outputCount > 0) {
                logger.debug("{}", (Object)sb);
                sb = new StringBuffer();
            }
        } else {
            int length;
            logger.debug("The response entity as a String in the default encoding:");
            for (int offset = 0; offset < bufferLength; offset += length) {
                length = bufferLength - offset;
                if (length > BREAK_POINT) {
                    length = BREAK_POINT;
                }
                String str = new String(buffer, offset, length);
                logger.debug("{}", (Object)str);
            }
        }
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        ClientResponse response = context.doChain(request);
        try {
            MultivaluedMap<String, String> headers = response.getHeaders();
            if (headers != null && headers.size() > 0) {
                Set headerKeys = headers.keySet();
                if (headerKeys.contains(null)) {
                    headerKeys.remove(null);
                }
                ArrayList keys = new ArrayList(headerKeys);
                StringBuilder sb = new StringBuilder();
                if (keys != null) {
                    Collections.sort(keys);
                    Formatter f = new Formatter(sb);
                    for (String k : keys) {
                        List values = (List)headers.get((Object)k);
                        for (String v : values) {
                            f.format("%n%1$-30s%2$s", k, v);
                        }
                    }
                }
                logger.debug("The received response headers:{}", (Object)sb);
            } else {
                logger.debug("There were no custom headers written on the response.");
            }
        }
        catch (Exception e) {
            logger.trace("Caught exception while trying to log server response headers", (Throwable)e);
        }
        return response;
    }

    public static class LoggedInputStream
    extends InputStream {
        private final InputStream originalResponse;
        private final byte[] requestBuffer;
        private int offset = 0;

        public LoggedInputStream(InputStream originalResponse, int bufferSize) {
            this.originalResponse = originalResponse;
            this.requestBuffer = new byte[bufferSize];
        }

        public int available() throws IOException {
            return this.originalResponse.available();
        }

        public void close() throws IOException {
            this.originalResponse.close();
        }

        public void mark(int readlimit) {
            this.originalResponse.mark(readlimit);
        }

        public boolean markSupported() {
            return this.originalResponse.markSupported();
        }

        public int read() throws IOException {
            int value = this.originalResponse.read();
            if (value < 0) {
                return value;
            }
            if (this.offset < this.requestBuffer.length - 1) {
                this.requestBuffer[this.offset] = (byte)value;
                ++this.offset;
            }
            return value;
        }

        public int read(byte[] b) throws IOException {
            int value = this.originalResponse.read(b);
            if (value < 0) {
                return value;
            }
            int diff = value;
            if (this.offset + value > this.requestBuffer.length) {
                diff = this.requestBuffer.length - this.offset;
            }
            if (diff > 0) {
                System.arraycopy(b, 0, this.requestBuffer, this.offset, diff);
                this.offset += diff;
            }
            return value;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int value = this.originalResponse.read(b, off, len);
            if (value < 0) {
                return value;
            }
            int diff = value;
            if (this.offset + value > this.requestBuffer.length) {
                diff = this.requestBuffer.length - this.offset;
            }
            if (diff > 0) {
                System.arraycopy(b, off, this.requestBuffer, this.offset, diff);
                this.offset += diff;
            }
            return value;
        }

        public void reset() throws IOException {
            this.originalResponse.reset();
        }

        public long skip(long n) throws IOException {
            return this.originalResponse.skip(n);
        }

        public byte[] getLoggedByteBuffer() {
            return this.requestBuffer;
        }

        public int getLoggedByteBufferLength() {
            return this.offset;
        }
    }
}

