/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.internal.handlers.AbstractConnectionHandler;
import org.apache.wink.client.internal.handlers.ClientResponseImpl;
import org.apache.wink.common.internal.WinkConfiguration;

public class ApacheHttpClientConnectionHandler
extends AbstractConnectionHandler {
    private HttpClient httpclient;

    public ApacheHttpClientConnectionHandler() {
        this.httpclient = null;
    }

    public ApacheHttpClientConnectionHandler(HttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        HttpResponse response = null;
        try {
            response = this.processRequest(request, context);
            return this.processResponse(request, context, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpResponse processRequest(ClientRequest request, HandlerContext context) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        NonCloseableOutputStream ncos;
        HttpClient client = this.openConnection(request);
        OutputStream os = ncos = new NonCloseableOutputStream();
        EntityWriter entityWriter = null;
        if (request.getEntity() != null) {
            os = this.adaptOutputStream(ncos, request, context.getOutputStreamAdapters());
            entityWriter = new EntityWriter(this, request, os, ncos);
        }
        HttpRequestBase entityRequest = this.setupHttpRequest(request, client, entityWriter);
        return client.execute((HttpUriRequest)entityRequest);
    }

    private HttpRequestBase setupHttpRequest(ClientRequest request, HttpClient client, EntityWriter entityWriter) {
        Object entityRequest;
        URI uri = request.getURI();
        String method = request.getMethod();
        Object httpRequest = null;
        if (entityWriter == null) {
            httpRequest = entityRequest = new GenericHttpRequestBase(method);
        } else {
            entityRequest = new GenericHttpEntityEnclosingRequestBase(method);
            entityRequest.setEntity(entityWriter);
            httpRequest = entityRequest;
        }
        httpRequest.setURI(uri);
        MultivaluedMap<String, String> headers = request.getHeaders();
        for (String header : headers.keySet()) {
            List values = (List)headers.get((Object)header);
            for (String value : values) {
                if (value == null) continue;
                httpRequest.addHeader(header, value);
            }
        }
        return httpRequest;
    }

    private HttpClient openConnection(ClientRequest request) throws NoSuchAlgorithmException, KeyManagementException {
        if (this.httpclient != null) {
            return this.httpclient;
        }
        ClientConfig config = (ClientConfig)request.getAttribute(WinkConfiguration.class);
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.connection.timeout", (Object)config.getConnectTimeout());
        params.setParameter("http.socket.timeout", (Object)config.getReadTimeout());
        params.setParameter("http.protocol.handle-redirects", (Object)config.isFollowRedirects());
        if (config.isFollowRedirects()) {
            params.setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        }
        if (config.getProxyHost() != null) {
            params.setParameter("http.route.default-proxy", (Object)new HttpHost(config.getProxyHost(), config.getProxyPort()));
        }
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)params);
        if (config.getBypassHostnameVerification()) {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
            SSLSocketFactory sf = new SSLSocketFactory(sslcontext);
            sf.setHostnameVerifier(new X509HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }
            });
            httpclient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sf, 443));
        }
        return httpclient;
    }

    private ClientResponse processResponse(ClientRequest request, HandlerContext context, HttpResponse httpResponse) throws IllegalStateException, IOException {
        ClientResponse response = this.createResponse(request, httpResponse);
        HttpEntity entity = httpResponse.getEntity();
        InputStream is = null;
        is = entity == null ? new EmptyInputStream() : entity.getContent();
        is = this.adaptInputStream(is, response, context.getInputStreamAdapters());
        response.setEntity(is);
        return response;
    }

    private ClientResponse createResponse(ClientRequest request, final HttpResponse httpResponse) {
        ClientResponseImpl response = new ClientResponseImpl();
        StatusLine statusLine = httpResponse.getStatusLine();
        response.setStatusCode(statusLine.getStatusCode());
        response.setMessage(statusLine.getReasonPhrase());
        response.getAttributes().putAll(request.getAttributes());
        response.setContentConsumer(new Runnable(){

            public void run() {
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    try {
                        entity.consumeContent();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        this.processResponseHeaders(response, httpResponse);
        return response;
    }

    private void processResponseHeaders(ClientResponse response, HttpResponse httpResponse) {
        Header[] allHeaders;
        for (Header header : allHeaders = httpResponse.getAllHeaders()) {
            response.getHeaders().add((Object)header.getName(), (Object)header.getValue());
        }
    }

    private static class EntityWriter
    implements HttpEntity {
        private ApacheHttpClientConnectionHandler apacheHttpClientHandler;
        private ClientRequest request;
        private OutputStream adaptedOutputStream;
        private NonCloseableOutputStream ncos;

        public EntityWriter(ApacheHttpClientConnectionHandler apacheHttpClientHandler, ClientRequest request, OutputStream adaptedOutputStream, NonCloseableOutputStream ncos) {
            this.apacheHttpClientHandler = apacheHttpClientHandler;
            this.request = request;
            this.adaptedOutputStream = adaptedOutputStream;
            this.ncos = ncos;
        }

        public void consumeContent() throws IOException {
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return null;
        }

        public Header getContentEncoding() {
            return null;
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            return null;
        }

        public boolean isChunked() {
            return true;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return true;
        }

        public void writeTo(OutputStream os) throws IOException {
            this.ncos.setOutputStream(os);
            this.apacheHttpClientHandler.writeEntity(this.request, this.adaptedOutputStream);
        }
    }

    private static class NonCloseableOutputStream
    extends OutputStream {
        OutputStream os;

        public void setOutputStream(OutputStream os) {
            this.os = os;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.os.write(b);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }
    }

    private static class GenericHttpEntityEnclosingRequestBase
    extends HttpEntityEnclosingRequestBase {
        private String method;

        public GenericHttpEntityEnclosingRequestBase(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }

    private static class GenericHttpRequestBase
    extends HttpRequestBase {
        private String method;

        public GenericHttpRequestBase(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }

    private static class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

