/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ConnectionHandler;
import org.apache.wink.client.handlers.InputStreamAdapter;
import org.apache.wink.client.handlers.OutputStreamAdapter;
import org.apache.wink.client.internal.ClientRuntimeContext;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionHandler
implements ConnectionHandler {
    protected OutputStream adaptOutputStream(OutputStream os, ClientRequest request, List<OutputStreamAdapter> outputStreamAdapters) throws IOException {
        for (OutputStreamAdapter adapter : outputStreamAdapters) {
            os = adapter.adapt(os, request);
        }
        return os;
    }

    protected InputStream adaptInputStream(InputStream is, ClientResponse response, List<InputStreamAdapter> inputStreamAdapters) throws IOException {
        for (InputStreamAdapter adapter : inputStreamAdapters) {
            is = adapter.adapt(is, response);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEntity(ClientRequest request, OutputStream os) throws WebApplicationException, IOException {
        Object entity = request.getEntity();
        if (entity == null) {
            return;
        }
        ProvidersRegistry providersRegistry = request.getAttribute(ProvidersRegistry.class);
        ClientRuntimeContext runtimeContext = new ClientRuntimeContext(providersRegistry);
        RuntimeContext saved = RuntimeContextTLS.getRuntimeContext();
        RuntimeContextTLS.setRuntimeContext(runtimeContext);
        try {
            Class type;
            Type genericType = type = entity.getClass();
            if (entity instanceof GenericEntity) {
                GenericEntity genericEntity = (GenericEntity)entity;
                type = genericEntity.getRawType();
                genericType = genericEntity.getType();
                entity = genericEntity.getEntity();
            }
            MessageBodyWriter writer = null;
            MediaType contentMediaType = null;
            String contentType = (String)request.getHeaders().getFirst((Object)"Content-Type");
            if (contentType == null) {
                contentMediaType = providersRegistry.getMessageBodyWriterMediaTypeLimitByIsWritable(type, runtimeContext);
                if (contentMediaType == null) {
                    contentType = "application/octet-stream";
                }
            } else {
                contentMediaType = MediaType.valueOf((String)contentType);
            }
            request.getHeaders().putSingle((Object)"Content-Type", (Object)contentMediaType.toString());
            writer = providersRegistry.getMessageBodyWriter(type, genericType, null, contentMediaType, runtimeContext);
            if (writer == null) {
                throw new RuntimeException(Messages.getMessage("clientNoWriterForTypeAndMediaType", String.valueOf(type), contentType));
            }
            writer.writeTo(entity, type, genericType, null, contentMediaType, request.getHeaders(), os);
            os.flush();
            os.close();
        }
        finally {
            RuntimeContextTLS.setRuntimeContext(saved);
        }
    }
}

