/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.handlers;

import com.ibm.websphere.security.web.WebSecurityHelper;
import javax.servlet.http.Cookie;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.AbstractAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtpaAuthSecurityHandler
extends AbstractAuthSecurityHandler
implements ClientHandler {
    private static Logger logger = LoggerFactory.getLogger(LtpaAuthSecurityHandler.class);

    @Override
    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        logger.debug("Entering LtpaAuthSecurityHandler.handle");
        if (this.isSSLRequired() && !request.getURI().getScheme().equalsIgnoreCase("https")) {
            logger.debug("Cannot send user credentials over a non-SSL connection");
            throw new ClientAuthenticationException(Messages.getMessage("userCredNotAllowedOverNonSSLConnection"));
        }
        ClientResponse response = context.doChain(request);
        int statusCode = response.getStatusCode();
        logger.debug("Response status code was {}", (Object)statusCode);
        if (statusCode != 401) {
            logger.debug("Status code was not 401 so no need to re-issue request.");
            return response;
        }
        logger.debug("Preparing to issue request again with Authorization header");
        logger.debug("About to get an LTPA authentication token");
        Cookie ssoCookie = WebSecurityHelper.getSSOCookieFromSSOToken();
        if (ssoCookie != null && ssoCookie.getValue() != null && !ssoCookie.getValue().isEmpty() && ssoCookie.getName() != null) {
            logger.debug("Retrieved an LTPA authentication token. About to set a request cookie");
            request.getHeaders().putSingle((Object)"Cookie", (Object)(ssoCookie.getName() + "=" + ssoCookie.getValue()));
            response = context.doChain(request);
            if (response.getStatusCode() == 401) {
                logger.debug("After sending request with Authorization header, still got 401 response");
                throw new ClientAuthenticationException(Messages.getMessage("serviceFailedToAuthenticateUserLTPA"));
            }
            logger.debug("Got a non-401 response, so returning response");
            logger.debug("Exiting LtpaAuthSecurityHandler.handle");
            return response;
        }
        logger.debug("cannot find an ltpa authentication token off of the thread");
        throw new ClientAuthenticationException(Messages.getMessage("missingClientAuthenticationCredentialForUserLTPA"));
    }
}

