/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.servlet.ServletWrapper;
import com.ibm.ws.cache.web.ServletCacheServiceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.cache.CacheManager;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ServletCacheEngine
implements CacheManager {
    private static TraceComponent tc = Tr.register(ServletCacheEngine.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private AtomicReference<ServletCacheServiceImpl> servletCacheServiceReference = new AtomicReference<Object>(null);
    protected static List<String> staticContentPolicies = new ArrayList<String>();
    public static Set<String> excludedServlets = new HashSet<String>(9);
    public static Set<String> contextRootsWithCachespecXMLs = new ConcurrentSkipListSet<String>();

    public Servlet getProxiedServlet(Servlet s) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProxiedServlet", (Object[])new Object[]{s});
        }
        try {
            String name = s.getClass().getName().toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking for ", (Object[])new Object[]{s.getServletConfig(), name});
            }
            if (null != s.getServletConfig()) {
                String contextRoot = s.getServletConfig().getServletContext().getContextPath();
                if ((null != this.getServletCache() || !excludedServlets.contains(name)) && contextRootsWithCachespecXMLs.contains(contextRoot)) {
                    s = new ServletWrapper(s);
                }
            } else {
                ModuleMetaData mmd;
                ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                if (cmd != null && (mmd = cmd.getModuleMetaData()) instanceof WebModuleMetaData) {
                    WebModuleMetaData wmmd = (WebModuleMetaData)mmd;
                    String contextRoot = wmmd.getConfiguration().getContextRoot();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Pulled out contextRoot ", (Object[])new Object[]{contextRoot});
                    }
                    if (this.isStaticFileCachingEnabled(contextRoot)) {
                        s = new ServletWrapper(s);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".getProxiedServlet()"), (String)"90");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProxiedServlet", (Object)s);
        }
        return s;
    }

    public void handleServlet(Servlet s, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CacheHook.handleServlet(s, req, res);
    }

    public static void addStaticContentPolicy(String uri) throws Exception {
        staticContentPolicies.add(uri);
    }

    public ServletCacheServiceImpl getServletCache() {
        return this.servletCacheServiceReference.get();
    }

    @Reference
    protected void setServletCache(ServletCacheServiceImpl sc) {
        this.servletCacheServiceReference.set(sc);
    }

    protected void unsetServletCache(ServletCacheServiceImpl serverCache) {
        this.servletCacheServiceReference.compareAndSet(serverCache, null);
    }

    public boolean isStaticFileCachingEnabled(String contextRoot) {
        return staticContentPolicies.contains(contextRoot);
    }

    static {
        excludedServlets.add("org.apache.jasper.runtime.JspServlet");
        excludedServlets.add("com.ibm.ws.webcontainer.jsp.servlet.JspServlet");
        excludedServlets.add("com.ibm.ws.webcontainer.servlet.InvokerServlet");
        excludedServlets.add("com.ibm.wps.portletcontainer.jasper.runtime.JspServlet");
        excludedServlets.add("com.ibm.ws.jsp.servlet.JspServlet");
        excludedServlets.add("com.ibm.ws.console.core.servlet.DownloadFileServlet");
        excludedServlets.add("com.ibm.ws.management.filetransfer.servlet.FileTransferServlet");
        excludedServlets.add("com.ibm.ws.portletcontainer.portletserving.PortletServingServlet");
        excludedServlets.add("com.ibm.ws.websvcs.transport.http.WASAxis2Servlet");
    }
}

