/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ExternalCacheAdapter;
import com.ibm.websphere.servlet.cache.ExternalCacheEntry;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.eca.ECAConnection;
import com.ibm.ws.cache.eca.ECAListener;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;

public class Afpa
extends Thread
implements ExternalCacheAdapter {
    private static TraceComponent tc = Tr.register(Afpa.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    boolean listening = false;
    ECAListener listener;
    ExternalCache[] externalCache = new ExternalCache[0];
    HashMap uris = new HashMap();

    @Override
    public void setAddress(String address) {
        try {
            if (this.listening) {
                return;
            }
            this.listener = new ECAListener(Integer.valueOf(address).intValue());
            this.setDaemon(true);
            this.start();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.setAddress", (String)"64", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (ECAListener.isAccepting()) {
            try {
                ECAConnection conn = (ECAConnection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Afpa.this.listener.accept();
                    }
                });
                InputStream is = conn.getInputStream();
                OutputStream os = conn.getOutputStream();
                DataOutputStream dos = new DataOutputStream(os);
                Afpa afpa = this;
                synchronized (afpa) {
                    ExternalCache[] newEXT = new ExternalCache[this.externalCache.length + 1];
                    System.arraycopy(this.externalCache, 0, newEXT, 0, this.externalCache.length);
                    newEXT[newEXT.length - 1] = new ExternalCache();
                    newEXT[newEXT.length - 1].dos = dos;
                    newEXT[newEXT.length - 1].is = is;
                    newEXT[newEXT.length - 1].connection = conn;
                    this.externalCache = newEXT;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Connected to an AFPA enabled server at" + conn.getInetAddress()), (Object[])new Object[0]);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.run", (String)"93", (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePages(Iterator externalCacheEntries) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writePages", (Object[])new Object[0]);
        }
        while (externalCacheEntries.hasNext()) {
            ExternalCacheEntry e = (ExternalCacheEntry)externalCacheEntries.next();
            String virtualHost = e.host;
            String uri = e.uri;
            HashSet<String> vhosts = (HashSet<String>)this.uris.get(uri);
            if (vhosts == null) {
                vhosts = new HashSet<String>();
                this.uris.put(uri, vhosts);
            }
            vhosts.add(virtualHost);
            this.fixupHeaderTable(e);
            String contentType = this.getHeader(e, "content-type");
            String contentEncoding = this.getHeader(e, "content-encoding");
            String contentLanguage = this.getHeader(e, "content-language");
            String contentCharset = this.getHeader(e, "content-charset");
            String eTag = this.getHeader(e, "etag");
            String expires = this.getHeader(e, "expires");
            String cacheControl = this.getHeader(e, "cache-control");
            Afpa afpa = this;
            synchronized (afpa) {
                for (int i = 0; i < this.externalCache.length; ++i) {
                    DataOutputStream dos = this.externalCache[i].dos;
                    try {
                        dos.writeInt(0);
                        dos.writeUTF(virtualHost);
                        dos.writeUTF(uri);
                        dos.writeInt(e.content.length);
                        dos.write(e.content, 0, e.content.length);
                        dos.writeUTF(contentType);
                        dos.writeUTF(contentEncoding);
                        dos.writeUTF(contentLanguage);
                        dos.writeUTF(contentCharset);
                        dos.writeUTF(eTag);
                        dos.writeUTF(expires);
                        dos.writeUTF(cacheControl);
                        dos.flush();
                        continue;
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.writePages", (String)"145", (Object)this);
                        this.removeConnection(i);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writePages");
        }
    }

    private synchronized void removeConnection(int removeIdx) {
        ExternalCache[] newEXT = new ExternalCache[this.externalCache.length - 1];
        int j = 0;
        for (int i = 0; i < this.externalCache.length; ++i) {
            if (i != removeIdx) {
                newEXT[j] = this.externalCache[i];
                ++j;
                continue;
            }
            try {
                this.externalCache[removeIdx].dos.close();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.removeConnection", (String)"163", (Object)this);
            }
            try {
                this.externalCache[removeIdx].is.close();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.removeConnection", (String)"166", (Object)this);
            }
            try {
                this.externalCache[removeIdx].connection.close();
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.removeConnection", (String)"169", (Object)this);
            }
        }
        this.externalCache = newEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidatePages(Iterator urls) {
        while (urls.hasNext()) {
            String uri = (String)urls.next();
            HashSet vhosts = (HashSet)this.uris.remove(uri);
            if (vhosts == null) continue;
            for (String virtualHost : vhosts) {
                Afpa afpa = this;
                synchronized (afpa) {
                    for (int i = 0; i < this.externalCache.length; ++i) {
                        DataOutputStream dos = this.externalCache[i].dos;
                        try {
                            dos.writeInt(1);
                            dos.writeUTF(virtualHost);
                            dos.writeUTF(uri);
                            dos.flush();
                            continue;
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.Afpa.invalidatePages", (String)"200", (Object)this);
                            this.removeConnection(i);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void clear() {
        while (this.externalCache.length != 0) {
            this.removeConnection(0);
        }
    }

    private void fixupHeaderTable(ExternalCacheEntry e) {
        for (int i = 0; i < e.headerTable[0].size(); ++i) {
            e.headerTable[0].setElementAt(((String)e.headerTable[0].elementAt(i)).toLowerCase(), i);
        }
    }

    private String getHeader(ExternalCacheEntry e, String name) {
        int index = e.headerTable[0].indexOf(name);
        if (index == -1) {
            return "";
        }
        return (String)e.headerTable[1].get(index);
    }

    @Override
    public void invalidateIds(Iterator ids) {
    }

    @Override
    public void preInvoke(ServletCacheRequest sreq, HttpServletResponse sresp) {
    }

    @Override
    public void postInvoke(ServletCacheRequest sreq, HttpServletResponse sresp) {
    }

    class ExternalCache {
        public DataOutputStream dos;
        public InputStream is;
        public ECAConnection connection;

        ExternalCache() {
        }
    }
}

