/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.app;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.app.ApplicationType;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ApplicationAdapter
implements ContainerAdapter<Application> {
    private ServiceReference<JavaEEVersion> versionRef;
    private volatile Version platformVersion = JavaEEVersion.DEFAULT_VERSION;
    static final long serialVersionUID = 9214549684165028145L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public synchronized void setVersion(ServiceReference<JavaEEVersion> reference) {
        this.versionRef = reference;
        this.platformVersion = Version.parseVersion((String)((String)reference.getProperty("version")));
    }

    public synchronized void unsetVersion(ServiceReference<JavaEEVersion> reference) {
        if (reference == this.versionRef) {
            this.versionRef = null;
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    @FFDCIgnore(value={DDParser.ParseException.class})
    public Application adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        Application appDD = (Application)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), Application.class);
        if (appDD != null) {
            return appDD;
        }
        Entry ddEntry = containerToAdapt.getEntry("META-INF/application.xml");
        if (ddEntry != null) {
            try {
                ApplicationDDParser ddParser = new ApplicationDDParser(containerToAdapt, ddEntry, this.platformVersion);
                appDD = ddParser.parse();
                rootOverlay.addToNonPersistentCache(artifactContainer.getPath(), Application.class, (Object)appDD);
                return appDD;
            }
            catch (DDParser.ParseException e) {
                throw new UnableToAdaptException((Throwable)e);
            }
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationAdapter.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ApplicationDDParser
    extends DDParser {
        private final Version eeVersion;
        private static final String APPLICATION_DTD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
        private static final String APPLICATION_DTD_PUBLIC_ID_13 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
        static final long serialVersionUID = -8702216992731015080L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationDDParser(Container ddRootContainer, Entry ddEntry, Version platformVersion) throws DDParser.ParseException {
            super(ddRootContainer, ddEntry);
            this.eeVersion = platformVersion;
        }

        Application parse() throws DDParser.ParseException {
            super.parseRootElement();
            return (Application)this.rootParsable;
        }

        @Override
        protected DDParser.ParsableElement createRootParsable() throws DDParser.ParseException {
            if (!"application".equals(this.rootElementLocalName)) {
                throw new DDParser.ParseException(this.invalidRootElement());
            }
            if (this.namespace == null) {
                if (this.dtdPublicId != null) {
                    if (APPLICATION_DTD_PUBLIC_ID_12.equals(this.dtdPublicId)) {
                        this.version = 12;
                        this.eePlatformVersion = 12;
                        return new ApplicationType(this.getDeploymentDescriptorPath());
                    }
                    if (APPLICATION_DTD_PUBLIC_ID_13.equals(this.dtdPublicId)) {
                        this.version = 13;
                        this.eePlatformVersion = 13;
                        return new ApplicationType(this.getDeploymentDescriptorPath());
                    }
                }
                throw new DDParser.ParseException(this.unknownDeploymentDescriptorVersion());
            }
            String vers = this.getAttributeValue("", "version");
            if (vers == null) {
                throw new DDParser.ParseException(this.missingDeploymentDescriptorVersion());
            }
            if ("http://java.sun.com/xml/ns/j2ee".equals(this.namespace)) {
                if ("1.4".equals(vers)) {
                    this.version = 14;
                    this.eePlatformVersion = 14;
                    return new ApplicationType(this.getDeploymentDescriptorPath());
                }
            } else if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                if ("5".equals(vers)) {
                    this.version = 50;
                    this.eePlatformVersion = 50;
                    return new ApplicationType(this.getDeploymentDescriptorPath());
                }
                if ("6".equals(vers)) {
                    this.version = 60;
                    this.eePlatformVersion = 60;
                    return new ApplicationType(this.getDeploymentDescriptorPath());
                }
            } else if (this.eeVersion.compareTo(JavaEEVersion.VERSION_7_0) >= 0 && "http://xmlns.jcp.org/xml/ns/javaee".equals(this.namespace) && "7".equals(vers)) {
                this.version = 70;
                this.eePlatformVersion = 70;
                return new ApplicationType(this.getDeploymentDescriptorPath());
            }
            throw new DDParser.ParseException(this.invalidDeploymentDescriptorNamespace(vers));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationDDParser.class);
        }
    }
}

