/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.jaxrs20.injection.metadata.ParamInjectionMetadata;
import com.ibm.ws.jaxrs20.server.LibertyJaxRsServerFactoryBean;
import com.ibm.ws.jaxrs20.server.ResourceUtils;
import com.ibm.ws.jaxrs20.server.component.JaxRsBeanValidation;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsInvoker
extends JAXRSInvoker {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsInvoker.class);
    private Class cxfBeanValidationProviderClass = null;
    private final Map<String, Method> cxfBeanValidationProviderMethodsMap = new HashMap<String, Method>();
    private boolean isEnableBeanValidatoin = false;
    private LibertyJaxRsServerFactoryBean libertyJaxRsServerFactoryBean = null;
    private volatile Object beanValidationProvider = null;
    private final String cxfBeanValidationProviderClassName = "org.apache.cxf.validation.BeanValidationProvider";
    private boolean validateServiceObject = true;
    static final long serialVersionUID = 832126513241513236L;

    public LibertyJaxRsInvoker(LibertyJaxRsServerFactoryBean libertyJaxRsServerFactoryBean, boolean isEnableBeanValidatoin) {
        this.libertyJaxRsServerFactoryBean = libertyJaxRsServerFactoryBean;
        this.isEnableBeanValidatoin = isEnableBeanValidatoin;
        if (isEnableBeanValidatoin && null == this.cxfBeanValidationProviderClass) {
            this.cxfBeanValidationProviderClass = JaxRsBeanValidation.getBeanValidationProviderClass();
            if (this.cxfBeanValidationProviderClass == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Bean Validation Provider Class not found", (Object[])new Object[0]);
                }
                return;
            }
            this.cacheValidationMethod("validateBean", new Class[]{Object.class});
            this.cacheValidationMethod("validateParameters", new Class[]{Object.class, Method.class, Object[].class});
            this.cacheValidationMethod("validateReturnValue", new Class[]{Object.class, Method.class, Object.class});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cacheValidationMethod(String methodName, Class[] paramTypes) {
        block4: {
            try {
                Method m = this.cxfBeanValidationProviderClass.getMethod(methodName, paramTypes);
                this.cxfBeanValidationProviderMethodsMap.put(methodName, m);
            }
            catch (NoSuchMethodException m) {
                FFDCFilter.processException((Throwable)m, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"98", (Object)((Object)this), (Object[])new Object[]{methodName, paramTypes});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Can't find method \"" + methodName + "\" for Bean Validation Provider. " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (SecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"102", (Object)((Object)this), (Object[])new Object[]{methodName, paramTypes});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Can't access method \"" + methodName + "\" for Bean Validation Provider due to security issue. " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        paramArray = this.insertExchange(m, paramArray, exchange);
        return this.libertyJaxRsServerFactoryBean.performInvocation(exchange, serviceObject, m, paramArray);
    }

    public Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        MessageContentsList list;
        Object realServiceObject;
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        if (!cri.isSingleton()) {
            Method postConstructMethod;
            Class<?> clazz = serviceObject.getClass();
            JaxRsFactoryBeanCustomizer beanCustomizer = this.libertyJaxRsServerFactoryBean.findBeanCustomizer(clazz);
            if (beanCustomizer != null) {
                realServiceObject = beanCustomizer.beforeServiceInvoke(serviceObject, cri.isSingleton(), this.libertyJaxRsServerFactoryBean.getBeanCustomizerContext(beanCustomizer));
                if (!(realServiceObject != serviceObject || beanCustomizer.getClass().getName().equalsIgnoreCase("com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer") || cri.contextsAvailable() || cri.paramsAvailable())) {
                    postConstructMethod = ResourceUtils.findPostConstructMethod(realServiceObject.getClass());
                    InjectionUtils.invokeLifeCycleMethod((Object)realServiceObject, (Method)postConstructMethod);
                }
            } else {
                realServiceObject = serviceObject;
                if (!cri.contextsAvailable() && !cri.paramsAvailable()) {
                    postConstructMethod = ResourceUtils.findPostConstructMethod(serviceObject.getClass());
                    InjectionUtils.invokeLifeCycleMethod((Object)serviceObject, (Method)postConstructMethod);
                }
            }
        } else {
            realServiceObject = serviceObject;
        }
        Message message = JAXRSUtils.getCurrentMessage();
        Object theProvider = null;
        if (this.isEnableBeanValidatoin && this.cxfBeanValidationProviderClass != null) {
            theProvider = this.getProvider(message);
            if (this.isValidateServiceObject()) {
                this.callValidationMethod("validateBean", new Object[]{realServiceObject}, theProvider);
            }
            this.callValidationMethod("validateParameters", new Object[]{realServiceObject, m, params.toArray()}, theProvider);
        }
        Object response = super.invoke(exchange, realServiceObject, m, params);
        if (this.isEnableBeanValidatoin && this.cxfBeanValidationProviderClass != null && theProvider != null && response instanceof MessageContentsList && (list = (MessageContentsList)response).size() == 1) {
            Object entity = list.get(0);
            if (entity instanceof Response) {
                this.callValidationMethod("validateReturnValue", new Object[]{realServiceObject, m, ((Response)entity).getEntity()}, theProvider);
            } else {
                this.callValidationMethod("validateReturnValue", new Object[]{realServiceObject, m, entity}, theProvider);
            }
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    protected Object getProvider(Message message) {
        block7: {
            if (this.beanValidationProvider == null) {
                Object prop = message.getContextualProperty(this.cxfBeanValidationProviderClassName);
                if (prop != null) {
                    this.beanValidationProvider = prop;
                } else {
                    try {
                        this.beanValidationProvider = this.cxfBeanValidationProviderClass.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"257", (Object)((Object)this), (Object[])new Object[]{message});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)("init Bean Validation Provider fails. " + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    catch (IllegalAccessException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.LibertyJaxRsInvoker", (String)"261", (Object)((Object)this), (Object[])new Object[]{message});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                        Tr.debug((TraceComponent)tc, (String)("Can't access the initialization of Bean Validation Provider. " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        return this.beanValidationProvider;
    }

    @FFDCIgnore(value={SecurityException.class, IllegalAccessException.class, IllegalArgumentException.class, InvocationTargetException.class})
    private void callValidationMethod(String methodName, Object[] paramValues, Object theProvider) {
        block11: {
            if (theProvider == null) {
                return;
            }
            Method m = this.cxfBeanValidationProviderMethodsMap.get(methodName);
            if (m == null) {
                return;
            }
            try {
                m.invoke(theProvider, paramValues);
            }
            catch (SecurityException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Can't access the method \"" + m.getName() + "\" due to security issue." + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Can't access the method \"" + m.getName() + "\"." + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (IllegalArgumentException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Illegal argument to the method \"" + m.getName() + "\"." + e.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (InvocationTargetException e) {
                Throwable validationException;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invocation of the method \"" + m.getName() + "\" fails" + e.getMessage()), (Object[])new Object[0]);
                }
                if (null == (validationException = e.getTargetException()) || !(validationException instanceof RuntimeException)) break block11;
                throw (RuntimeException)validationException;
            }
        }
    }

    public void setProvider(Object provider) {
        if (provider == null) {
            return;
        }
        if (!provider.getClass().getName().equals(this.cxfBeanValidationProviderClassName)) {
            return;
        }
        this.beanValidationProvider = provider;
    }

    public boolean isValidateServiceObject() {
        return this.validateServiceObject;
    }

    public void setValidateServiceObject(boolean validateServiceObject) {
        this.validateServiceObject = validateServiceObject;
    }

    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        JaxRsFactoryBeanCustomizer beanCustomizer = this.libertyJaxRsServerFactoryBean.findBeanCustomizer(resourceObject.getClass());
        if (beanCustomizer != null) {
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
            Message inMessage = exchange.getInMessage();
            InjectionRuntimeContext irc = InjectionRuntimeContextHelper.getRuntimeContext();
            ParamInjectionMetadata pimd = new ParamInjectionMetadata(ori, inMessage);
            irc.setRuntimeCtxObject(ParamInjectionMetadata.class.getName(), (Object)pimd);
        }
        return super.invoke(exchange, request, resourceObject);
    }
}

