/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.futures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.esa.internal.futures.AbstractElementFuture;
import com.ibm.ws.app.manager.esa.internal.futures.ESAAggregateFuture;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.blueprint.utils.HeaderParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class BlueprintFuture
extends AbstractElementFuture
implements BlueprintListener {
    private final ServiceRegistration<BlueprintListener> reg;
    protected final Map<Bundle, Integer> states = new ConcurrentHashMap<Bundle, Integer>();
    static final long serialVersionUID = 5856787304831484924L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BlueprintFuture(BundleContext ctx, Bundle[] bundlesForThisApp, ESAAggregateFuture aggregate) {
        super(aggregate);
        for (Bundle bundle : bundlesForThisApp) {
            if (!this.isBlueprintBundle(bundle)) continue;
            this.states.put(bundle, 0);
        }
        if (!this.states.isEmpty()) {
            this.reg = ctx.registerService(BlueprintListener.class, (Object)this, null);
        } else {
            this.reg = null;
            this.esaAggregate.getMonitor().setResult(this.elementFuture, (Object)null);
        }
    }

    private boolean isBlueprintBundle(Bundle bundle) {
        BundleRevision br = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (br == null || (br.getTypes() & 1) != 0) {
            return false;
        }
        String blueprintHeader = (String)bundle.getHeaders().get("Bundle-Blueprint");
        String blueprintHeaderAnnotation = (String)bundle.getHeaders().get("Bundle-Blueprint-Annotation");
        if (blueprintHeaderAnnotation != null && blueprintHeaderAnnotation.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (blueprintHeader == null) {
            blueprintHeader = "OSGI-INF/blueprint/";
        }
        int blueprintXmls = 0;
        for (HeaderParser.PathElement e : HeaderParser.parseHeader((String)blueprintHeader)) {
            String searchPattern;
            String path = e.getName();
            if (path.endsWith("/")) {
                searchPattern = "*.xml";
            } else {
                String[] elements = path.split("/", 2);
                if (elements.length == 1) {
                    searchPattern = path;
                    path = "/";
                } else {
                    searchPattern = elements[1];
                    path = elements[0] + "/";
                }
            }
            Enumeration urls = bundle.findEntries(path, searchPattern, false);
            while (urls != null && urls.hasMoreElements()) {
                ++blueprintXmls;
                urls.nextElement();
            }
        }
        return blueprintXmls > 0;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    public void blueprintEvent(BlueprintEvent event) {
        Bundle b = event.getBundle();
        if (this.states.keySet().contains(b)) {
            this.states.put(b, event.getType());
            if (this.blueprintComplete()) {
                this.esaAggregate.getMonitor().setResult(this.elementFuture, (Object)null);
                try {
                    if (this.reg != null) {
                        this.reg.unregister();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    abstract boolean blueprintComplete();

    protected boolean blueprintComplete(List<Integer> validCompletionStates) {
        boolean result = true;
        for (int state : this.states.values()) {
            result &= validCompletionStates.contains(state);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BlueprintFuture.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class BlueprintStartFuture
    extends BlueprintFuture {
        static final long serialVersionUID = -5982023982014019825L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BlueprintStartFuture(BundleContext ctx, Bundle[] bundlesForThisApp, ESAAggregateFuture aggregate) {
            super(ctx, bundlesForThisApp, aggregate);
        }

        @Override
        boolean blueprintComplete() {
            return this.blueprintComplete(Arrays.asList(2, 5));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BlueprintStartFuture.class);
        }
    }
}

