/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.LibraryAccess;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.eba.wab.integrator.EbaProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.library.Library;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ManagedServiceFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.app.manager.esa.library"})
public class OsgiLibraryConfiguration
implements ManagedServiceFactory {
    private static final Pattern VALID_JAVA_PACKAGE;
    private static final String LIBRARY_REF_ATT = "libraryRef";
    private static final String PACKAGE_ATT = "package";
    static final String SERVICE_PID = "com.ibm.ws.app.manager.esa.library";
    private final ConcurrentMap<String, OsgiLibrary> instances = new ConcurrentHashMap<String, OsgiLibrary>();
    private BundleContext context;
    private LibraryAccess libraryAccess;
    private EbaProvider ebaProvider;
    static final long serialVersionUID = -6592248528689891676L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean isValidJavaPackage(String name) {
        return VALID_JAVA_PACKAGE.matcher(name).matches();
    }

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
    }

    @Reference
    protected void setLibraryAccess(LibraryAccess libraryAccess) {
        this.libraryAccess = libraryAccess;
    }

    protected void unsetLibraryAccess(LibraryAccess libraryAccess) {
        this.libraryAccess = null;
    }

    @Reference
    protected void setEbaProvider(EbaProvider ebaProvider) {
        this.ebaProvider = ebaProvider;
    }

    protected void unsetEbaProvider(EbaProvider ebaProvider) {
        this.ebaProvider = null;
    }

    public String getName() {
        return "Osgi Library";
    }

    public void deleted(String pid) {
        OsgiLibrary osgiLibrary = (OsgiLibrary)this.instances.remove(pid);
        if (osgiLibrary != null) {
            osgiLibrary.unconfigure();
        }
    }

    public void updated(String pid, Dictionary<String, ?> config) throws ConfigurationException {
        if (FrameworkState.isStopping()) {
            return;
        }
        OsgiLibrary osgiLibrary = new OsgiLibrary(pid);
        OsgiLibrary current = this.instances.putIfAbsent(pid, osgiLibrary);
        if (current != null) {
            osgiLibrary = current;
        }
        osgiLibrary.update(this.context, config, this.libraryAccess, this.ebaProvider);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OsgiLibraryConfiguration.class);
        VALID_JAVA_PACKAGE = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class OsgiLibrary {
        private final String pid;
        ReentrantLock trackerLock = new ReentrantLock();
        ServiceTracker<Library, LibraryPackages> tracker;
        static final long serialVersionUID = 5722357512335045124L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OsgiLibrary(String pid) {
            this.pid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void update(final BundleContext context, Dictionary<String, ?> config, final LibraryAccess libraryAccess, final EbaProvider ebaProvider) {
            Filter filter;
            String libraryRef = (String)config.get(OsgiLibraryConfiguration.LIBRARY_REF_ATT);
            String libraryStatusFilter = String.format("(&(objectClass=%s)(|(id=%s)(service.pid=%s)))", Library.class.getName(), libraryRef, libraryRef);
            try {
                filter = context.createFilter(libraryStatusFilter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.app.manager.esa.internal.OsgiLibraryConfiguration$OsgiLibrary", (String)"241", (Object)this, (Object[])new Object[]{context, config, libraryAccess, ebaProvider});
                throw new RuntimeException((Throwable)e);
            }
            String[] packageArray = (String[])config.get(OsgiLibraryConfiguration.PACKAGE_ATT);
            final List<Object> packages = packageArray == null ? Collections.emptyList() : Arrays.asList(packageArray);
            ServiceTracker newTracker = null;
            newTracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Library, LibraryPackages>(){
                static final long serialVersionUID = 1966344948124725398L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public LibraryPackages addingService(ServiceReference<Library> libraryRef) {
                    Library library = (Library)context.getService(libraryRef);
                    LibraryPackages libraryPackages = new LibraryPackages(libraryAccess, library, packages, context, OsgiLibrary.this.pid, ebaProvider);
                    libraryPackages.configure();
                    return libraryPackages;
                }

                public void modifiedService(ServiceReference<Library> libraryRef, LibraryPackages libraryPackages) {
                    libraryPackages.unconfigure();
                    libraryPackages.configure();
                }

                public void removedService(ServiceReference<Library> libraryRef, LibraryPackages libraryPackages) {
                    libraryPackages.unconfigure();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            this.trackerLock.lock();
            try {
                if (this.tracker != null) {
                    this.tracker.close();
                }
                this.tracker = newTracker;
                this.tracker.open();
            }
            finally {
                this.trackerLock.unlock();
            }
        }

        static List<String> scanForPackages(Library library) {
            LinkedHashSet<String> packages = new LinkedHashSet<String>();
            Collection containers = library.getContainers();
            for (ArtifactContainer container : containers) {
                OsgiLibrary.scanForPackages(container, packages);
            }
            return new ArrayList<String>(packages);
        }

        static void scanForPackages(ArtifactContainer container, Set<String> packages) {
            for (ArtifactEntry entry : container) {
                String path;
                String packageName;
                ArtifactContainer entryContainer = entry.convertToContainer(true);
                if (entryContainer == null || !OsgiLibraryConfiguration.isValidJavaPackage(packageName = (path = entry.getPath()).substring(1).replace('/', '.'))) continue;
                packages.add(packageName);
                OsgiLibrary.scanForPackages(entryContainer, packages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unconfigure() {
            this.trackerLock.lock();
            try {
                if (this.tracker != null) {
                    this.tracker.close();
                    this.tracker = null;
                }
            }
            finally {
                this.trackerLock.unlock();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OsgiLibrary.class);
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        static class LibraryPackages
        implements OsgiLibraryMarker,
        ApplicationRecycleComponent {
            private final LibraryAccess libraryAccess;
            private final Library library;
            private final List<String> packages;
            private final BundleContext context;
            private final String pid;
            private final FrameworkWiring fwkWiring;
            private final EbaProvider ebaProvider;
            private volatile ServiceRegistration<?> marker;
            static final long serialVersionUID = 1871141981538240341L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public LibraryPackages(LibraryAccess libraryAccess, Library library, List<String> packages, BundleContext context, String pid, EbaProvider ebaProvider) {
                this.libraryAccess = libraryAccess;
                this.library = library;
                if (packages.isEmpty()) {
                    packages = OsgiLibrary.scanForPackages(library);
                }
                this.packages = new ArrayList<String>(packages);
                this.context = context;
                this.pid = pid;
                this.ebaProvider = ebaProvider;
                this.fwkWiring = (FrameworkWiring)context.getBundle("System Bundle").adapt(FrameworkWiring.class);
                ListIterator<String> iPackages = this.packages.listIterator();
                while (iPackages.hasNext()) {
                    iPackages.set(iPackages.next() + "; ibm.pid=" + pid);
                }
            }

            void configure() {
                this.libraryAccess.setPackages(this.library, this.packages, LibraryAccess.PackageVisibility.OSGI_APPS);
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("service.pid", this.pid);
                this.marker = this.context.registerService(new String[]{OsgiLibraryMarker.class.getName(), ApplicationRecycleComponent.class.getName()}, (Object)this, props);
            }

            void unconfigure() {
                this.marker.unregister();
                this.libraryAccess.setPackages(this.library, Collections.emptyList(), LibraryAccess.PackageVisibility.OSGI_APPS);
            }

            public ApplicationRecycleContext getContext() {
                return null;
            }

            public Set<String> getDependentApplications() {
                Collection packages = this.fwkWiring.findProviders((Requirement)new PackageRequirement(this.pid));
                if (packages.isEmpty()) {
                    return Collections.emptySet();
                }
                HashSet<Bundle> dependants = new HashSet<Bundle>();
                BundleWiring wiring = ((BundleCapability)packages.iterator().next()).getRevision().getWiring();
                for (BundleWire pkgWire : wiring.getProvidedWires("osgi.wiring.package")) {
                    dependants.add(pkgWire.getRequirer().getBundle());
                }
                HashSet<String> result = new HashSet<String>();
                for (Bundle dependant : dependants) {
                    ApplicationInfo appInfo = this.ebaProvider.getApplicationInfo(dependant);
                    if (appInfo == null) continue;
                    result.add(appInfo.getName());
                }
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(LibraryPackages.class);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class PackageRequirement
    implements Requirement {
        private final String pidFilter;
        static final long serialVersionUID = -5758518553338600285L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PackageRequirement(String pid) {
            this.pidFilter = "(ibm.pid=" + pid + ")";
        }

        public String getNamespace() {
            return "osgi.wiring.package";
        }

        public Map<String, String> getDirectives() {
            return Collections.singletonMap("filter", this.pidFilter);
        }

        public Map<String, Object> getAttributes() {
            return Collections.emptyMap();
        }

        public Resource getResource() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PackageRequirement.class);
        }
    }

    static interface OsgiLibraryMarker {
    }
}

