/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.esa.adapter.IFileAdapter;
import com.ibm.ws.app.manager.esa.internal.SubsystemHandler;
import com.ibm.ws.app.manager.esa.internal.SubsystemInformation;
import com.ibm.ws.app.manager.esa.internal.futures.ESAStartFuture;
import com.ibm.ws.app.manager.module.ApplicationNestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.subsystem.AriesSubsystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class DeploySubsystemAction
implements CompletionListener<Boolean>,
ResolverHookFactory {
    private static final TraceComponent _tc = Tr.register(DeploySubsystemAction.class);
    private static List<Requirement> AUTO_IMPORTS = Arrays.asList(new SubsystemHandler.SyntheticRequirement("osgi.service", "(|(objectClass=javax.transaction.TransactionSynchronizationRegistry)(osgi.jndi.url.scheme=*)(objectClass=javax.transaction.UserTransaction))"), new SubsystemHandler.SyntheticRequirement("osgi.service", "(osgi.jndi.service.name=*)"));
    private final ApplicationInformation<SubsystemInformation> _subsystemInfo;
    private final SubsystemHandler _handler;
    private ExtendedApplicationInfo _appInfo;
    private IDirectory _iDirectory;
    private boolean _fireStarting = false;
    private boolean _storedApplication;
    private boolean _fireStarted = false;
    private AriesSubsystem _subsystem = null;
    private final AtomicReference<ResolutionReport> _reportRef = new AtomicReference();
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final ThreadLocal<Boolean> _startingThread = new ThreadLocal<Boolean>(){
        static final long serialVersionUID = 5641419840699657322L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 112505438542190L;

    public DeploySubsystemAction(ApplicationInformation<SubsystemInformation> subsystemInfo, SubsystemHandler handler) {
        this._subsystemInfo = subsystemInfo;
        this._handler = handler;
    }

    Future<Boolean> deploy() {
        Future<Boolean> result = this.preDeploy();
        if (result != null) {
            return result;
        }
        return this.deploySubsystem();
    }

    /*
     * WARNING - void declaration
     */
    private Future<Boolean> preDeploy() {
        Container container = this._subsystemInfo.getContainer();
        if (this._subsystemInfo.getLocation().regionMatches(true, this._subsystemInfo.getLocation().length() - ".xml".length(), ".xml", 0, ".xml".length())) {
            this._handler.getContainers().put(this._subsystemInfo.getPid(), container);
            try {
                NonPersistentCache oc = (NonPersistentCache)container.adapt(NonPersistentCache.class);
                oc.addToCache(IFileAdapter.class, (Object)this._subsystemInfo.getPid());
            }
            catch (UnableToAdaptException oc) {
                void utae;
                FFDCFilter.processException((Throwable)oc, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"127", (Object)this, (Object[])new Object[0]);
                return this.failAndCreateFalseFuture((Throwable)utae);
            }
        }
        try {
            this._iDirectory = (IDirectory)container.adapt(IDirectory.class);
        }
        catch (UnableToAdaptException utae) {
            FFDCFilter.processException((Throwable)utae, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"134", (Object)this, (Object[])new Object[0]);
            return this.failAndCreateFalseFuture(utae);
        }
        String name = this._subsystemInfo.getName();
        ApplicationNestedConfigHelper configHelper = new ApplicationNestedConfigHelper(this._subsystemInfo);
        try {
            StateChangeService stateChange;
            this._appInfo = this._handler.getApplicationInfoFactory().createApplicationInfo(name, name, container, null, (NestedConfigHelper)configHelper);
            MetaDataService metaData = this._handler.getMetaDataService();
            if (metaData != null) {
                metaData.fireApplicationMetaDataCreated(this._appInfo.getMetaData(), container);
            }
            if ((stateChange = this._handler.getStateChangeService()) != null) {
                this._fireStarting = true;
                stateChange.fireApplicationStarting((ApplicationInfo)this._appInfo);
            }
        }
        catch (Exception metaData) {
            void ex;
            FFDCFilter.processException((Throwable)metaData, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"152", (Object)this, (Object[])new Object[0]);
            return this.failAndCreateFalseFuture((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SubsystemException.class})
    private Future<Boolean> deploySubsystem() {
        ESAStartFuture startFuture;
        try {
            startFuture = this.installSubsystem();
            if (startFuture != null) {
                return startFuture;
            }
            startFuture = this.createStartSubsystemFuture();
        }
        catch (SubsystemException e) {
            return this.handleSubsystemException(e);
        }
        catch (Throwable e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"171", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"deploySubsystem", (Object)this);
            return this.failAndCreateFalseFuture((Throwable)t);
        }
        this._handler.getFutureMonitor().onCompletion((Future)startFuture, (CompletionListener)this);
        return startFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Boolean> installSubsystem() {
        Object object = this._handler.getSubsystemInstallUninstallLock();
        synchronized (object) {
            AriesSubsystem sharedSubsystem = this._handler.getSharedSubsystem();
            DeploySubsystemAction.addAutoImports(this._subsystemInfo.getPid(), this._handler);
            this._subsystem = sharedSubsystem.install(this._subsystemInfo.getPid(), this._iDirectory);
        }
        if (!this._subsystemInfo.getPid().equals(this._subsystem.getLocation())) {
            SubsystemInformation subsystemInformation = (SubsystemInformation)this._handler.getApplications().get(this._subsystem.getLocation());
            String otherAppName = subsystemInformation == null ? null : subsystemInformation.getApplicationInfo().getName();
            Tr.audit((TraceComponent)_tc, (String)"esa.installer.duplicate.application", (Object[])new Object[]{this._appInfo.getName(), this._subsystem.getSymbolicName(), this._subsystem.getVersion(), otherAppName});
            return this.failAndCreateFalseFuture(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(this + ", installed " + this._subsystemInfo.getPid()), (Object[])new Object[0]);
        }
        return null;
    }

    private ESAStartFuture createStartSubsystemFuture() {
        SubsystemInformation subsystemInformation = this.createSubsystemInformation(this._subsystem, this._handler.getApplicationInfoFactory(), (ApplicationInfo)this._appInfo);
        this._subsystemInfo.setHandlerInfo((Object)subsystemInformation);
        boolean bl = this._storedApplication = this._handler.getApplications().putIfAbsent(this._subsystemInfo.getPid(), subsystemInformation) == null;
        if (this._storedApplication) {
            subsystemInformation.register(this._handler.getContext());
        }
        Future<Boolean> installsCompleteFuture = this._handler.getInstallsCalledListener().getInstallsCompleteFuture();
        final Future startCompleteFuture = this._handler.getFutureMonitor().createFuture(Boolean.class);
        ESAStartFuture esaStartFuture = new ESAStartFuture(startCompleteFuture, (Subsystem)this._subsystem, this._handler.getContext(), this._handler.getFutureMonitor());
        if (installsCompleteFuture.isDone()) {
            this._handler.getFutureMonitor().setResult(startCompleteFuture, (Object)Boolean.TRUE);
            this.startSubsystem();
        } else {
            this._handler.getFutureMonitor().onCompletion(installsCompleteFuture, (CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = -415764062256078142L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    this.asyncStartSubsystem();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    this.asyncStartSubsystem();
                }

                private void asyncStartSubsystem() {
                    DeploySubsystemAction.this._handler.getExecutor().execute(new Runnable(){
                        static final long serialVersionUID = -6047082549048398362L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        @FFDCIgnore(value={SubsystemException.class})
                        public void run() {
                            try {
                                DeploySubsystemAction.this.startSubsystem();
                                DeploySubsystemAction.this._handler.getFutureMonitor().setResult(startCompleteFuture, (Object)Boolean.TRUE);
                            }
                            catch (SubsystemException e) {
                                this.setFailure(DeploySubsystemAction.this.handleSubsystemException(e));
                            }
                            catch (Throwable e) {
                                void t;
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction$2$1", (String)"257", (Object)this, (Object[])new Object[0]);
                                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"deploySubsystem", (Object)this);
                                this.setFailure(DeploySubsystemAction.this.failAndCreateFalseFuture((Throwable)t));
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        private void setFailure(Future<Boolean> failed) {
                            try {
                                DeploySubsystemAction.this._handler.getFutureMonitor().setResult(startCompleteFuture, (Object)failed.get());
                            }
                            catch (Throwable throwable) {
                                void t;
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction$2$1", (String)"267", (Object)this, (Object[])new Object[]{failed});
                                Throwable cause = t.getCause();
                                DeploySubsystemAction.this._handler.getFutureMonitor().setResult(startCompleteFuture, (Throwable)(cause == null ? t : cause));
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        return esaStartFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSubsystem() {
        this._startingThread.set(Boolean.TRUE);
        ServiceRegistration diagResolverHookReg = this._handler.getContext().registerService(ResolverHookFactory.class, (Object)this, null);
        try {
            this._subsystem.start();
        }
        finally {
            diagResolverHookReg.unregister();
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(this + ", started " + this._subsystemInfo.getPid()), (Object[])new Object[0]);
        }
    }

    private Future<Boolean> handleSubsystemException(SubsystemException e) {
        Throwable t;
        Map unresolved;
        ResolutionReport report = this._reportRef.get();
        if (report != null && !(unresolved = report.getEntries()).isEmpty()) {
            HashSet<Bundle> bundleConstituents = new HashSet<Bundle>();
            for (Resource constituent : this._subsystem.getConstituents()) {
                if (!(constituent instanceof BundleReference)) continue;
                bundleConstituents.add(((BundleReference)constituent).getBundle());
            }
            StringBuilder reportMessage = new StringBuilder();
            for (Resource resource : unresolved.keySet()) {
                if (!(resource instanceof BundleReference) || !bundleConstituents.contains(((BundleReference)resource).getBundle())) continue;
                reportMessage.append(report.getResolutionReportMessage(resource));
            }
            if (reportMessage.length() > 0) {
                reportMessage.insert(0, '\n');
                Tr.audit((TraceComponent)_tc, (String)"esa.installer.resolver.fail", (Object[])new Object[]{this._appInfo.getName(), reportMessage.toString()});
                return this.failAndCreateFalseFuture(null);
            }
        }
        if ((t = e.getCause()) instanceof ResolutionException) {
            Tr.audit((TraceComponent)_tc, (String)"esa.installer.aries.resolver.fail", (Object[])new Object[]{this._appInfo.getName(), t.getLocalizedMessage()});
            return this.failAndCreateFalseFuture(null);
        }
        if (t instanceof BundleException) {
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"deploySubsystem", (Object)this);
            if (4 == ((BundleException)t).getType()) {
                Tr.audit((TraceComponent)_tc, (String)"esa.installer.resolver.fail", (Object[])new Object[]{this._appInfo.getName(), t.getLocalizedMessage()});
            } else {
                Tr.audit((TraceComponent)_tc, (String)"esa.installer.bundle.fail", (Object[])new Object[]{this._appInfo.getName(), t.getLocalizedMessage()});
            }
            return this.failAndCreateFalseFuture(null);
        }
        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"deploySubsystem", (Object)this);
        Tr.audit((TraceComponent)_tc, (String)"esa.installer.aries.management.fail", (Object[])new Object[]{this._appInfo.getName(), e.getLocalizedMessage()});
        return this.failAndCreateFalseFuture(null);
    }

    @FFDCIgnore(value={InvalidSyntaxException.class})
    private SubsystemInformation createSubsystemInformation(AriesSubsystem subsystem, ApplicationInfoFactory applicationInfoFactory, ApplicationInfo appInfo) {
        String subsystemFilter = "(subsystem.id=" + subsystem.getSubsystemId() + ")";
        try {
            Collection references = this._handler.getContext().getServiceReferences(Subsystem.class, subsystemFilter);
            if (references.isEmpty()) {
                throw new IllegalStateException("The subsystem has alread been unregistered.");
            }
            return new SubsystemInformation((Subsystem)subsystem, (ServiceReference<Subsystem>)((ServiceReference)references.iterator().next()), applicationInfoFactory, appInfo);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Future<Boolean> failAndCreateFalseFuture(Throwable t) {
        if (this._handler.isApplicationDebugEnabled()) {
            return this._handler.getFutureMonitor().createFutureWithResult((Object)Boolean.TRUE);
        }
        this.fail();
        if (t != null) {
            return this._handler.getFutureMonitor().createFutureWithResult(Boolean.class, t);
        }
        return this._handler.getFutureMonitor().createFutureWithResult((Object)Boolean.FALSE);
    }

    @FFDCIgnore(value={InvalidSyntaxException.class})
    static void addAutoImports(final String location, SubsystemHandler handler) {
        String filter = "(objectClass=" + Subsystem.class.getName() + ")";
        final BundleContext context = handler.getContext();
        ServiceListener autoImportListener = new ServiceListener(){
            static final long serialVersionUID = 8027192289161767855L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void serviceChanged(ServiceEvent event) {
                AriesSubsystem subsystem = (AriesSubsystem)context.getService(event.getServiceReference());
                if (subsystem == null) {
                    return;
                }
                try {
                    if (!location.equals(subsystem.getLocation())) {
                        return;
                    }
                    Subsystem.State state = (Subsystem.State)event.getServiceReference().getProperty("subsystem.state");
                    switch (state) {
                        case INSTALLING: {
                            return;
                        }
                        case INSTALLED: {
                            subsystem.addRequirements((Collection)AUTO_IMPORTS);
                        }
                        default: {
                            context.removeServiceListener((ServiceListener)this);
                            return;
                        }
                    }
                }
                finally {
                    context.ungetService(event.getServiceReference());
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        try {
            context.addServiceListener(autoImportListener, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fail() {
        if (!this.failed.compareAndSet(false, true)) {
            return;
        }
        this._handler.getContainers().remove(this._subsystemInfo.getPid());
        if (this._storedApplication) {
            SubsystemInformation info = (SubsystemInformation)this._handler.getApplications().remove(this._subsystemInfo.getPid());
            info.unregister();
        }
        if (this._fireStarted) {
            try {
                this._handler.getStateChangeService().fireApplicationStopping((ApplicationInfo)this._appInfo);
            }
            catch (Throwable info) {
                void t;
                FFDCFilter.processException((Throwable)info, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"429", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopping", (Object)this);
            }
        }
        if (this._subsystem != null) {
            try {
                this._subsystem.stop();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"437", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"subsystemStop", (Object)this);
            }
            try {
                this._subsystem.uninstall();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"442", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"subsystemUninstall", (Object)this);
            }
        }
        if (this._appInfo != null) {
            if (this._fireStarting) {
                try {
                    this._handler.getStateChangeService().fireApplicationStopped((ApplicationInfo)this._appInfo);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"451", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopped", (Object)this);
                }
            }
            try {
                this._handler.getMetaDataService().fireApplicationMetaDataDestroyed(this._appInfo.getMetaData());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"458", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationMetaDataDestroyed", (Object)this);
            }
            try {
                this._handler.getApplicationInfoFactory().destroyApplicationInfo((ApplicationInfo)this._appInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"464", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"destroyApplicationInfo", (Object)this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void successfulCompletion(Future<Boolean> future, Boolean result) {
        if (result.booleanValue()) {
            this._fireStarted = true;
            StateChangeService stateChange = this._handler.getStateChangeService();
            if (stateChange != null) {
                try {
                    stateChange.fireApplicationStarted((ApplicationInfo)this._appInfo);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.esa.internal.DeploySubsystemAction", (String)"478", (Object)this, (Object[])new Object[]{future, result});
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStarted", (Object)this);
                    this.fail();
                }
            }
        } else {
            this.fail();
        }
    }

    public void failedCompletion(Future<Boolean> future, Throwable t) {
        FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"deployFailed");
        this.fail();
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        if (this._startingThread.get().booleanValue()) {
            return new DiagResolverHook();
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class DiagResolverHook
    implements ResolverHook,
    ResolutionReport.Listener {
        static final long serialVersionUID = -1906937330389793316L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DiagResolverHook() {
        }

        public void handleResolutionReport(ResolutionReport report) {
            DeploySubsystemAction.this._reportRef.compareAndSet(null, report);
        }

        public void filterResolvable(Collection<BundleRevision> candidates) {
        }

        public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
        }

        public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        }

        public void end() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DiagResolverHook.class);
        }
    }
}

