/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.adapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.EntryAdapter;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.equinox.module.ModuleLocationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IFileAdapter
implements EntryAdapter<IFile> {
    static final long serialVersionUID = -6400058818329943454L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IFile adapt(Container root, OverlayContainer rootOverlay, ArtifactEntry artifactEntry, Entry entryToAdapt) throws UnableToAdaptException {
        return new EntryBasedIFile(entryToAdapt);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IFileAdapter.class);
    }

    @TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class EntryBasedIFile
    implements IFile {
        private static final TraceComponent tc = Tr.register(EntryBasedIFile.class);
        private final Entry delegate;
        static final long serialVersionUID = 371561303243106278L;

        public EntryBasedIFile(Entry delegate) {
            this.delegate = delegate;
        }

        @FFDCIgnore(value={UnableToAdaptException.class})
        public IDirectory convert() {
            IDirectory idir = null;
            try {
                Container c = (Container)this.delegate.adapt(Container.class);
                if (c != null && !c.isRoot()) {
                    idir = (IDirectory)c.adapt(IDirectory.class);
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                // empty catch block
            }
            return idir;
        }

        @FFDCIgnore(value={UnableToAdaptException.class})
        public IDirectory convertNested() {
            IDirectory idir = null;
            try {
                Container c = (Container)this.delegate.adapt(Container.class);
                if (c != null && c.isRoot()) {
                    idir = (IDirectory)c.adapt(IDirectory.class);
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                // empty catch block
            }
            return idir;
        }

        public long getLastModified() {
            return this.delegate.getLastModified();
        }

        @Trivial
        public String getName() {
            String result = this.delegate.getPath();
            if (!result.isEmpty() && result.charAt(0) == '/') {
                result = result.substring(1);
            }
            return result;
        }

        @FFDCIgnore(value={UnableToAdaptException.class})
        public IDirectory getParent() {
            IDirectory idir = null;
            Container parent = this.delegate.getEnclosingContainer();
            if (parent != null) {
                try {
                    idir = (IDirectory)parent.adapt(IDirectory.class);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    // empty catch block
                }
            }
            return idir;
        }

        @FFDCIgnore(value={UnableToAdaptException.class})
        public IDirectory getRoot() {
            IDirectory idir = null;
            Container parent = this.delegate.getRoot();
            if (parent != null) {
                try {
                    idir = (IDirectory)parent.adapt(IDirectory.class);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    // empty catch block
                }
            }
            return idir;
        }

        public long getSize() {
            return this.delegate.getSize();
        }

        @FFDCIgnore(value={UnableToAdaptException.class})
        public boolean isDirectory() {
            boolean isDir = false;
            try {
                Container c = (Container)this.delegate.adapt(Container.class);
                if (c != null && !c.isRoot()) {
                    isDir = true;
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                // empty catch block
            }
            return isDir;
        }

        public boolean isFile() {
            return !this.isDirectory();
        }

        /*
         * WARNING - void declaration
         */
        public InputStream open() throws IOException, UnsupportedOperationException {
            boolean isroot = false;
            try {
                Container c = (Container)this.delegate.adapt(Container.class);
                if (c != null) {
                    isroot = c.isRoot();
                }
            }
            catch (UnableToAdaptException c) {
                FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.app.manager.esa.adapter.IFileAdapter$EntryBasedIFile", (String)"169", (Object)this, (Object[])new Object[0]);
            }
            InputStream is = null;
            try {
                is = (InputStream)this.delegate.adapt(InputStream.class);
                if (is == null && isroot) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" IFA: returning loose property jar stream for " + this.delegate.getPath() + " as inputstream=null & isroot=true"), (Object[])new Object[0]);
                    }
                    NonPersistentCache oc = (NonPersistentCache)this.delegate.getRoot().adapt(NonPersistentCache.class);
                    String pid = (String)oc.getFromCache(IFileAdapter.class);
                    String location = pid + "!" + this.delegate.getPath();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" IFA: Location =" + location + " in loose property jar"), (Object[])new Object[0]);
                    }
                    return ModuleLocationUtils.getInputStreamForLooseModule((String)location);
                }
            }
            catch (UnableToAdaptException oc) {
                void utae;
                FFDCFilter.processException((Throwable)oc, (String)"com.ibm.ws.app.manager.esa.adapter.IFileAdapter$EntryBasedIFile", (String)"199", (Object)this, (Object[])new Object[0]);
                throw new IOException((Throwable)utae);
            }
            return is;
        }

        public URL toURL() throws MalformedURLException {
            return this.delegate.getResource();
        }

        @Trivial
        public String toString() {
            return "IFileAdapter wrapping file with url " + this.delegate.getResource();
        }
    }
}

