/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.zos.AngelUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.ComponentContext;

public class ZosAio {
    private static final TraceComponent tc = Tr.register(ZosAio.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static boolean isZosaioEnabled = false;
    private static final Object LOCK = new Object();
    private static boolean asyncIOEnabledProperty = true;
    public static final String AIOENABLE_PROPERTYNAME = "com.ibm.ws.tcpchannel.useZosAio";
    private AngelUtils angelUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZosAioRegistered() {
        Object object = LOCK;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("isZosaioEnabled = " + isZosaioEnabled), (Object[])new Object[0]);
            }
            return isZosaioEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(Map<String, Object> props) {
        Object object = LOCK;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Activating ZOSAIO", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("props: " + props), (Object[])new Object[0]);
            }
            if (asyncIOEnabledProperty) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"ZOSAIO config is enabled", (Object[])new Object[0]);
                }
                if (this.isAsyncIOAuthorized()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"ZOSAIO is authorized and enabled", (Object[])new Object[0]);
                    }
                    isZosaioEnabled = true;
                    Tr.info((TraceComponent)tc, (String)"ZOSAIO_ACTIVATED", (Object[])new Object[0]);
                }
            }
        }
    }

    protected boolean isAsyncIOAuthorized() {
        HashSet<String> asyncIOServiceNames = new HashSet<String>(Arrays.asList("AIOINIT", "AIOCONN", "AIOIOEV2", "AIOCALL", "AIOCLEAR", "AIOCANCL", "AIOSHDWN", "AIOCPORT", "AIOGSOC"));
        return this.angelUtils.areServicesAvailable(asyncIOServiceNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        Object object = LOCK;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivating ZOSAIO", (Object[])new Object[0]);
            }
            isZosaioEnabled = false;
            if (asyncIOEnabledProperty) {
                Tr.info((TraceComponent)tc, (String)"ZOSAIO_DEACTIVATED", (Object[])new Object[0]);
            }
        }
    }

    protected void setAngelUtils(AngelUtils angelUtils) {
        this.angelUtils = angelUtils;
    }

    protected void unsetAngelUtils(AngelUtils angelUtils) {
        this.angelUtils = null;
    }

    static {
        AccessController.doPrivileged(new PrivSysPropCheck());
    }

    static class PrivSysPropCheck
    implements PrivilegedAction<Object> {
        @Override
        public Object run() {
            asyncIOEnabledProperty = Boolean.parseBoolean(System.getProperty(ZosAio.AIOENABLE_PROPERTYNAME, "true"));
            return null;
        }
    }
}

