/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.FCWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.TCPBaseRequestContext;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.List;

public abstract class TCPWriteRequestContextImpl
extends TCPBaseRequestContext
implements TCPWriteRequestContext {
    private static final long FILE_CHANNEL_SEGMENT_SIZE = 4096000L;
    private TCPWriteCompletedCallback callback;
    private static final TraceComponent tc = Tr.register(TCPWriteRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    protected TCPWriteRequestContextImpl(TCPConnLink value) {
        super(value);
        this.setRequestTypeRead(false);
    }

    @Override
    public long write(long numBytes, int time) throws IOException {
        int timeout = time;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("write(" + numBytes + "," + timeout + ")"), (Object[])new Object[0]);
        }
        this.getTCPConnLink().incrementNumWrites();
        if (this.getConfig().getDumpStatsInterval() > 0) {
            this.getTCPConnLink().getTCPChannel().totalSyncWrites.incrementAndGet();
        }
        this.checkForErrors(numBytes, false, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.getTCPConnLink().getSocketIOChannel().getSocket();
            Tr.event((TraceComponent)tc, (String)("write (sync) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        long numUserBytesWritten = 0L;
        if (this.isAborted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Previously aborted, unable to perform write", (Object[])new Object[0]);
            }
            throw new IOException("Connection aborted by program");
        }
        if (timeout == -2) {
            this.immediateTimeout();
        } else if (timeout == -3) {
            this.abort();
            this.immediateTimeout();
        } else {
            if (timeout == 0) {
                timeout = this.getConfig().getInactivityTimeout();
            }
            numUserBytesWritten = this.isFileChannelWriteToBeDone() ? this.fileChannelWrite(numBytes, timeout) : this.processSyncWriteRequest(numBytes, timeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("write(sync): " + numUserBytesWritten));
        }
        return numUserBytesWritten;
    }

    private boolean isFileChannelWriteToBeDone() {
        if ((this.getBuffer().getStatus() & 2) != 0) {
            if (this.getTCPConnLink().getVirtualConnection().isFileChannelCapable()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"FileChannel writing is enabled", (Object[])new Object[0]);
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FileChannel writing is disabled", (Object[])new Object[0]);
            }
            int _status = this.getBuffer().getStatus();
            _status &= 0xFFFFFFFD;
            this.getBuffer().setStatus(_status |= 1);
        }
        return false;
    }

    private long fileChannelWrite(long minBytesToWrite, long timeout) throws IOException {
        FileChannel fc;
        boolean possibleTimeout;
        long minAllWrites;
        long startPosition;
        long totalWritten;
        block17: {
            long maxToWrite = 0L;
            totalWritten = 0L;
            long numWritten = 0L;
            long size = 0L;
            startPosition = 0L;
            minAllWrites = 0L;
            long startTime = 0L;
            possibleTimeout = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("fileChannelWrite(" + minBytesToWrite + ", " + timeout + ")"), (Object[])new Object[0]);
            }
            SocketChannel sc = this.getTCPConnLink().getSocketIOChannel().getChannel();
            FCWsByteBufferImpl fcb = (FCWsByteBufferImpl)this.getBuffer();
            fc = fcb.getFileChannel();
            startTime = CHFWBundle.getApproxTime();
            try {
                size = fc.size();
                startPosition = fc.position();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("size:" + size + " pos:" + startPosition), (Object[])new Object[0]);
                }
                minAllWrites = minBytesToWrite == -1L ? size - startPosition : minBytesToWrite;
                while (totalWritten < minAllWrites) {
                    maxToWrite = size - totalWritten - startPosition;
                    if (maxToWrite > 4096000L) {
                        maxToWrite = 4096000L;
                    }
                    try {
                        numWritten = fc.transferTo(startPosition + totalWritten, maxToWrite, sc);
                    }
                    catch (IOException ioe) {
                        if (ioe.getMessage().contains("Resource temporarily unavailable")) {
                            numWritten = 0L;
                        }
                        throw ioe;
                    }
                    if (numWritten == 0L) {
                        Thread.yield();
                    } else {
                        totalWritten += numWritten;
                    }
                    if (CHFWBundle.getApproxTime() - startTime > timeout) {
                        possibleTimeout = true;
                        break;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("transferTo wrote: " + numWritten + " total:" + totalWritten), (Object[])new Object[0]);
                }
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IOException: " + e), (Object[])new Object[0]);
                }
                if (totalWritten >= minAllWrites) break block17;
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".fileChannelWrite"), (String)"190", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileChannelWrite: IOException Thrown");
                }
                throw e;
            }
        }
        fc.position(startPosition + totalWritten);
        if (possibleTimeout && totalWritten < minAllWrites) {
            SocketTimeoutException e = new SocketTimeoutException("Socket operation, used by a File Channel, timed out before it could be completed");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileChannelWrite: SocketTimeoutException Thrown");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("fileChannelWrite: " + totalWritten));
        }
        return totalWritten;
    }

    protected String getStackTrace(Throwable oThrowable) {
        if (null == oThrowable) {
            return null;
        }
        StringWriter oStringWriter = new StringWriter();
        PrintWriter oPrintWriter = new PrintWriter(oStringWriter);
        oThrowable.printStackTrace(oPrintWriter);
        oPrintWriter.close();
        return oStringWriter.toString();
    }

    public abstract long processSyncWriteRequest(long var1, int var3) throws IOException;

    @Override
    public VirtualConnection write(long numBytes, TCPWriteCompletedCallback writeCallback, boolean forceQueue, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("write(" + numBytes + ",..," + forceQueue + "," + timeout + ")"), (Object[])new Object[0]);
        }
        this.getTCPConnLink().incrementNumWrites();
        if (this.getConfig().getDumpStatsInterval() > 0) {
            this.getTCPConnLink().getTCPChannel().totalAsyncWrites.incrementAndGet();
        }
        this.checkForErrors(numBytes, true, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.getTCPConnLink().getSocketIOChannel().getSocket();
            Tr.event((TraceComponent)tc, (String)("write (async) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        VirtualConnection vc = null;
        if (this.isAborted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Previously aborted, unable to perform write", (Object[])new Object[0]);
            }
            if (null != writeCallback) {
                IOException ioe = new IOException("Connection aborted by program");
                writeCallback.error(this.getTCPConnLink().getVirtualConnection(), this, ioe);
            }
        } else {
            vc = this.writeInternal(numBytes, writeCallback, forceQueue, timeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("write: " + vc));
        }
        return vc;
    }

    protected VirtualConnection writeInternal(long numBytes, TCPWriteCompletedCallback writeCallback, boolean forceQueue, int time) {
        int timeout = time;
        if (timeout == -2) {
            this.immediateTimeout();
            return null;
        }
        if (timeout == -3) {
            this.abort();
            this.immediateTimeout();
            return null;
        }
        if (timeout == 0) {
            timeout = this.getConfig().getInactivityTimeout();
        }
        this.setIOAmount(numBytes);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setWriteCompletedCallback(writeCallback);
        this.setForceQueue(forceQueue);
        this.setTimeoutTime(timeout);
        return this.processAsyncWriteRequest();
    }

    public abstract VirtualConnection processAsyncWriteRequest();

    private void checkForErrors(long numBytes, boolean isAsync, int _timeout) {
        if (_timeout == -2 || _timeout == -3) {
            return;
        }
        String errorMsg = null;
        if (numBytes > Integer.MAX_VALUE) {
            errorMsg = "Number of bytes to requested to write: " + numBytes + " exceeds the maximum allowed for one write";
        }
        if (isAsync && this.getBuffer() != null && (this.getBuffer().getStatus() & 2) != 0) {
            this.getBuffer().setStatus(1);
        }
        if (this.getBuffers() == null || this.getBuffers().length == 0) {
            errorMsg = "No buffer(s) provided for writing data from";
        } else if ((this.getBuffer().getStatus() & 2) == 0) {
            if (this.getBuffers() == null || this.getBuffers().length == 0) {
                errorMsg = "No buffer(s) provided for writing data from";
            } else if (numBytes < -1L || numBytes == 0L && isAsync) {
                errorMsg = "Number of bytes requested to write: " + numBytes + " is not valid";
            } else {
                WsByteBuffer[] wsBuffArray = this.getBuffers();
                long bytesAvail = 0L;
                for (int bufNum = 0; bufNum < this.getBuffers().length && wsBuffArray[bufNum] != null; ++bufNum) {
                    bytesAvail += (long)(wsBuffArray[bufNum].limit() - wsBuffArray[bufNum].position());
                }
                if (numBytes > bytesAvail || bytesAvail == 0L) {
                    errorMsg = "Number of bytes requested: " + numBytes + " exceeds space remaining in the buffers provided: " + bytesAvail;
                }
            }
        } else {
            FCWsByteBufferImpl fcb = (FCWsByteBufferImpl)this.getBuffer();
            try {
                long space;
                if (fcb.getFileChannel().size() > Integer.MAX_VALUE) {
                    errorMsg = "Number of possible bytes in the File Channel:  " + fcb.getFileChannel().size() + " exceeds maximum allowed: " + Integer.MAX_VALUE;
                }
                if (numBytes > (long)((int)(space = (long)(fcb.limit() - fcb.position())))) {
                    errorMsg = "Number of bytes requested: " + numBytes + " exceeds bytes remaining in the FileChannel: " + space;
                }
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)(this.getClass().getName() + ".checkForErrors"), (String)"377", (Object)this);
                errorMsg = "space remaining in FileChannel cannot be determined.";
            }
        }
        if (errorMsg != null) {
            IllegalArgumentException iae = new IllegalArgumentException(errorMsg);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)iae, (String)this.getClass().getName(), (String)"100", (Object)this);
            throw iae;
        }
    }

    protected void setWriteCompletedCallback(TCPWriteCompletedCallback cb) {
        this.callback = cb;
    }

    public TCPWriteCompletedCallback getWriteCompletedCallback() {
        return this.callback;
    }

    protected abstract void immediateTimeout();

    public ByteBuffer preProcessOneWriteBuffer() {
        WsByteBufferImpl wsBuffImpl = null;
        try {
            wsBuffImpl = (WsByteBufferImpl)this.getBuffer();
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Writing with a non-WsByteBufferImpl", (Object[])new Object[0]);
            }
            return this.getBuffer().getWrappedByteBuffer();
        }
        if (!wsBuffImpl.isDirect() && wsBuffImpl.hasArray()) {
            wsBuffImpl.copyToDirectBuffer();
            return wsBuffImpl.oWsBBDirect;
        }
        return wsBuffImpl.getWrappedByteBufferNonSafe();
    }

    public ByteBuffer[] preProcessWriteBuffers() {
        int i;
        WsByteBuffer[] wsBuffArray = this.getBuffers();
        boolean containsNonDirect = false;
        for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
            if (wsBuffArray[i].isDirect() || !wsBuffArray[i].hasArray()) continue;
            containsNonDirect = true;
            break;
        }
        if (!containsNonDirect) {
            return this.getByteBufferArray();
        }
        try {
            for (i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
                ((WsByteBufferImpl)wsBuffArray[i]).copyToDirectBuffer();
            }
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Writing with a non-WsByteBufferImpl, may hurt performance", (Object[])new Object[0]);
            }
            return this.getByteBufferArray();
        }
        this.setBuffersToDirect(wsBuffArray);
        return this.getByteBufferArrayDirect();
    }

    public void postProcessWriteBuffers(long dataWritten) {
        if (this.getByteBufferArrayDirect() == null) {
            try {
                if (((WsByteBufferImpl)this.getBuffer()).oWsBBDirect != null) {
                    ((WsByteBufferImpl)this.getBuffer()).setParmsFromDirectBuffer();
                }
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
            return;
        }
        WsByteBuffer[] wsBuffArray = this.getBuffers();
        for (int i = 0; i < wsBuffArray.length && wsBuffArray[i] != null; ++i) {
            try {
                ((WsByteBufferImpl)wsBuffArray[i]).setParmsFromDirectBuffer();
                continue;
            }
            catch (ClassCastException cce) {
                return;
            }
        }
    }

    @Override
    public List<String> introspect() {
        List<String> rc = super.introspect();
        String prefix = this.getClass().getSimpleName() + "@" + this.hashCode() + ": ";
        rc.add(prefix + "callback=" + this.callback);
        return rc;
    }

    @Override
    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }
}

