/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.ValidateUtils;
import com.ibm.ws.tcpchannel.internal.ZosAio;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCPFactoryConfiguration
implements FFDCSelfIntrospectable {
    private static final String CLASS_NAME = TCPFactoryConfiguration.class.getName();
    private static final TraceComponent tc = Tr.register(TCPFactoryConfiguration.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected static final String KEYS_PER_SELECTOR = "maxKeysPerSelector";
    protected static final String SELECTOR_IDLE_TIMEOUT = "channelSelectorIdleTimeout";
    protected static final String SELECTOR_TERM_TIMEOUT = "channelSelectorWaitToTerminate";
    protected static final String SELECTOR_YIELD = "selectorYield";
    protected static final String SELECTOR_WAKEUP = "selectorWakeup";
    protected static final String CANCEL_KEY_ON_CLOSE = "cancelKeyOnClose";
    protected static final String COMBINE_SELECTORS = "combineSelectors";
    protected static final String COMM_CLASS = "commClass";
    protected static final String EARLY_BINDS = "earlyBinds";
    private Map<Object, Object> commonProperties = null;
    private static int maxKeysPerSelector = 500;
    private static long channelSelectorIdleTimeout = 300000L;
    private static long channelSelectorWaitToTerminate = 10000L;
    private static int selectorWakeup = 1;
    private static boolean selectorYield = false;
    private static boolean cancelKeyOnClose = false;
    private static boolean combineSelectors = false;
    private static final String commClassAio = "com.ibm.ws.tcpchannel.internal.AioTCPChannel";
    private static final String commClassNio = "com.ibm.ws.tcpchannel.internal.NioTCPChannel";
    private static String commClass = "com.ibm.ws.tcpchannel.internal.NioTCPChannel";
    private static HashMap earlyBinds = null;
    private final String channelName = "*";
    private static String osName = null;

    public TCPFactoryConfiguration(Map<Object, Object> properties) throws ChannelFactoryException {
        this.setValues(properties);
    }

    protected void setValues(Map<Object, Object> oCommonConfig) throws ChannelFactoryException {
        boolean overrideCancelKeySetting = false;
        this.commonProperties = oCommonConfig;
        if (TCPFactoryConfiguration.isWindows()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Running on Windows, defaulting selectorYield to true", (Object[])new Object[0]);
            }
            selectorYield = true;
        } else if (TCPFactoryConfiguration.isISeries()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Running on iSeries, defaulting maxKeysPerSelector to 50", (Object[])new Object[0]);
            }
            maxKeysPerSelector = 50;
        } else if (TCPFactoryConfiguration.isSun()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Running on Sun, defaulting cancelKeyOnCloseSetting to true", (Object[])new Object[0]);
            }
            overrideCancelKeySetting = true;
            cancelKeyOnClose = true;
        }
        if (this.commonProperties != null) {
            Set<Object> keySet = this.commonProperties.keySet();
            Iterator<Object> keys = keySet.iterator();
            String key = null;
            String value = null;
            Object entry = null;
            int result = 0;
            int minValue = 0;
            int maxValue = 0;
            int keyType = 0;
            while (keys.hasNext() && result == 0) {
                key = (String)keys.next();
                entry = this.commonProperties.get(key);
                if (key.equalsIgnoreCase(EARLY_BINDS)) {
                    earlyBinds = (HashMap)entry;
                    keyType = 4;
                    result = 0;
                    continue;
                }
                if (!(entry instanceof String)) continue;
                value = (String)entry;
                try {
                    if (key.equalsIgnoreCase(KEYS_PER_SELECTOR)) {
                        keyType = 0;
                        minValue = 1;
                        maxValue = 20000;
                        maxKeysPerSelector = Integer.parseInt(value);
                        result = ValidateUtils.testKeysPerSelector(maxKeysPerSelector);
                        continue;
                    }
                    if (key.equalsIgnoreCase(SELECTOR_IDLE_TIMEOUT)) {
                        keyType = 0;
                        minValue = 0;
                        maxValue = 3600000;
                        channelSelectorIdleTimeout = Long.parseLong(value);
                        result = ValidateUtils.testChannelSelectorIdleTimeout(channelSelectorIdleTimeout);
                        continue;
                    }
                    if (key.equalsIgnoreCase(SELECTOR_TERM_TIMEOUT)) {
                        keyType = 0;
                        minValue = 0;
                        maxValue = 3600;
                        channelSelectorWaitToTerminate = Long.parseLong(value);
                        result = ValidateUtils.testChannelSelectorWaitToTerminate(channelSelectorWaitToTerminate);
                        if (result != 0) continue;
                        channelSelectorWaitToTerminate *= 1000L;
                        continue;
                    }
                    if (key.equalsIgnoreCase(CANCEL_KEY_ON_CLOSE)) {
                        if (overrideCancelKeySetting) continue;
                        keyType = 2;
                        cancelKeyOnClose = Boolean.parseBoolean(value);
                        result = 0;
                        continue;
                    }
                    if (key.equalsIgnoreCase(SELECTOR_YIELD)) {
                        keyType = 2;
                        selectorYield = Boolean.parseBoolean(value);
                        result = 0;
                        continue;
                    }
                    if (key.equalsIgnoreCase(SELECTOR_WAKEUP)) {
                        keyType = 0;
                        minValue = 1;
                        maxValue = 3;
                        selectorWakeup = Integer.parseInt(value);
                        result = ValidateUtils.testChannelSelectorWakeupOption(selectorWakeup);
                        continue;
                    }
                    if (key.equalsIgnoreCase(COMBINE_SELECTORS)) {
                        keyType = 2;
                        combineSelectors = Boolean.parseBoolean(value);
                        result = 0;
                        continue;
                    }
                    if (key.equalsIgnoreCase(COMM_CLASS)) {
                        keyType = 1;
                        commClass = value;
                        result = 0;
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object[])new Object[]{this.channelName, key, value});
                }
                catch (NumberFormatException x) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object[])new Object[]{this.channelName, key, value});
                    ChannelFactoryException e = new ChannelFactoryException("The TCP Factory caught a NumberFormatException processing property, Channel Name: " + this.channelName + " Property name: " + key + " value: " + value, x);
                    FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"101", (Object)this);
                    throw e;
                }
            }
            if (result != 0) {
                ChannelFactoryException e = null;
                if (keyType == 0) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_INT", (Object[])new Object[]{this.channelName, key, value, "" + minValue, "" + maxValue});
                    e = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + key + " value: " + value + "minimum Value: " + minValue + "maximum Value: " + maxValue);
                } else if (keyType == 2) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_BOOLEAN", (Object[])new Object[]{this.channelName, key, value});
                    e = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + key + " value: " + value + " Valid Range: false, true");
                } else if (value == null) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_NULL_STRING", (Object[])new Object[]{this.channelName, key});
                    e = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + key + " value: null");
                } else {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_STRING", (Object[])new Object[]{this.channelName, key, value});
                    e = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + key + " value: " + value);
                }
                FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"102", (Object)this);
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.outputConfigToTrace();
            }
        }
    }

    protected void checkAndSetValues(Map<Object, Object> oCommonConfig) throws ChannelFactoryException {
        this.setValues(oCommonConfig);
    }

    protected static int getMaxKeysPerSelector() {
        return maxKeysPerSelector;
    }

    protected static long getChannelSelectorIdleTimeout() {
        return channelSelectorIdleTimeout;
    }

    protected static long getChannelSelectorWaitToTerminate() {
        return channelSelectorWaitToTerminate;
    }

    protected static boolean getSelectorYield() {
        return selectorYield;
    }

    protected static boolean getCancelKeyOnClose() {
        return cancelKeyOnClose;
    }

    protected static int getSelectorWakeup() {
        return selectorWakeup;
    }

    protected static boolean getCombineSelectors() {
        return combineSelectors;
    }

    public static String getCommClass() {
        if (commClass != null && commClass.equals(commClassNio) && ZosAio.isZosAioRegistered()) {
            commClass = commClassAio;
        }
        return commClass;
    }

    protected static Map getEarlyBinds() {
        return earlyBinds;
    }

    protected void outputConfigToTrace() {
        Tr.debug((TraceComponent)tc, (String)"Config parameters for TCP Channel Factory: ", (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("maxKeysPerSelector: " + maxKeysPerSelector), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("channelSelectorIdleTimeout: " + channelSelectorIdleTimeout), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("channelSelectorWaitToTerminate: " + channelSelectorWaitToTerminate), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("selectorYield: " + selectorYield), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("cancelKeyOnClose: " + cancelKeyOnClose), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("combineSelectors: " + combineSelectors), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("commClass: " + commClass), (Object[])new Object[0]);
    }

    public String[] introspectSelf() {
        String[] rc = new String[]{KEYS_PER_SELECTOR + maxKeysPerSelector, SELECTOR_IDLE_TIMEOUT + channelSelectorIdleTimeout, SELECTOR_TERM_TIMEOUT + channelSelectorWaitToTerminate, SELECTOR_YIELD + selectorYield, CANCEL_KEY_ON_CLOSE + cancelKeyOnClose, COMBINE_SELECTORS + combineSelectors, COMM_CLASS + commClass};
        return rc;
    }

    protected static String getOSName() {
        if (osName == null) {
            osName = System.getProperty("os.name", "unknown");
        }
        return osName;
    }

    protected static boolean isSun() {
        String name = TCPFactoryConfiguration.getOSName();
        return name.indexOf("SunOS") != -1 || name.indexOf("Solaris") != -1;
    }

    protected static boolean isHPUX() {
        String name = TCPFactoryConfiguration.getOSName();
        return name.indexOf("HP-UX") != -1;
    }

    protected static boolean isWindows() {
        String name = TCPFactoryConfiguration.getOSName();
        return name.toLowerCase().startsWith("windows");
    }

    protected static boolean isISeries() {
        String name = TCPFactoryConfiguration.getOSName();
        return name.equalsIgnoreCase("os/400");
    }
}

