/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.ChannelTermination;
import com.ibm.ws.tcpchannel.internal.NioTCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.ZosAio;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.CrossRegionSharable;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class TCPChannelFactory
implements ChannelFactory,
CrossRegionSharable {
    private static final TraceComponent tc = Tr.register(TCPChannelFactory.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static final Class<?> appSideClass = TCPConnectionContext.class;
    private Hashtable<String, ChannelTermination> terminationList = new Hashtable();
    private static String commClassName = null;
    private static Class<?> commClass = null;
    private Map<String, Channel> existingChannels = new HashMap<String, Channel>();
    private Map<Object, Object> commonProperties = null;

    @Override
    public boolean isSharable(Map<String, ChannelData> channelConfiguration) {
        return false;
    }

    @Override
    public void init(ChannelFactoryData data) throws ChannelFactoryException {
        new TCPFactoryConfiguration(data.getProperties());
        commClassName = TCPFactoryConfiguration.getCommClass();
        if (commClassName != null) {
            String name;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using comm class name [" + commClassName + "]"), (Object[])new Object[0]);
            }
            boolean loaded = false;
            final ClassLoader cl = TCPChannelFactory.class.getClassLoader();
            if (cl != null) {
                try {
                    name = commClassName;
                    commClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return cl.loadClass(name);
                        }
                    });
                    loaded = true;
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("loadClass failed; " + e), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".init"), (String)"132", (Object)this);
                }
            }
            if (!loaded) {
                try {
                    name = commClassName;
                    commClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return Class.forName(name);
                        }
                    });
                    loaded = true;
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Class.forName failed; " + e), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".init"), (String)"144", (Object)this);
                }
            }
        }
    }

    @Override
    public void updateProperties(Map<Object, Object> properties) {
        block2: {
            this.commonProperties = properties;
            try {
                new TCPFactoryConfiguration(properties);
            }
            catch (ChannelFactoryException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Unable to consume property updates", (Object[])new Object[0]);
            }
        }
    }

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        ChannelTermination ct;
        boolean isOverrideClassUsed;
        TCPChannel channel;
        TCPChannelConfiguration newCC;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createChannel", (Object[])new Object[0]);
            }
            newCC = new TCPChannelConfiguration(channelData);
            channel = null;
            isOverrideClassUsed = false;
            if (!newCC.isNIOOnly() && commClass != null && ZosAio.isZosAioRegistered()) {
                try {
                    channel = (TCPChannel)commClass.newInstance();
                    ct = channel.setup(channelData, newCC, this);
                    if (ct != null) {
                        this.terminationList.put(commClassName, ct);
                    }
                    isOverrideClassUsed = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("using CommClass: " + commClass), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("Exception trying to instantiate CommClass: " + e), (Object[])new Object[0]);
                }
            }
        }
        if (!isOverrideClassUsed && (ct = (channel = new NioTCPChannel()).setup(channelData, newCC, this)) != null) {
            this.terminationList.put("NioTCPChannel", ct);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createChannel");
        }
        return channel;
    }

    @Override
    public Class<?> getApplicationInterface() {
        return appSideClass;
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        for (ChannelTermination ct : this.terminationList.values()) {
            ct.terminate();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    @Override
    public synchronized Channel findOrCreateChannel(ChannelData channelData) throws ChannelException {
        String channelName;
        Channel ret;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findOrCreateChannel: " + channelData.getName()), (Object[])new Object[0]);
        }
        if ((ret = this.existingChannels.get(channelName = channelData.getName())) == null) {
            ret = this.createChannel(channelData);
            this.existingChannels.put(channelName, ret);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findOrCreateChannel");
        }
        return ret;
    }

    public synchronized void removeChannel(String channelName) {
        this.existingChannels.remove(channelName);
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.commonProperties;
    }

    @Override
    public final Class<?>[] getDeviceInterface() {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    @Override
    public OutboundChannelDefinition getOutboundChannelDefinition(Map<Object, Object> props) {
        return new TCPOutboundDefinition(props);
    }

    private static class TCPOutboundDefinition
    implements OutboundChannelDefinition {
        private static final long serialVersionUID = -7427145547238486815L;

        protected TCPOutboundDefinition(Map<Object, Object> props) {
        }

        @Override
        public Map<Object, Object> getOutboundChannelProperties() {
            return null;
        }

        @Override
        public Class<?> getOutboundFactory() {
            return TCPChannelFactory.class;
        }

        @Override
        public Map<Object, Object> getOutboundFactoryProperties() {
            return null;
        }
    }
}

