/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.ChannelTermination;
import com.ibm.ws.tcpchannel.internal.ConnectionManager;
import com.ibm.ws.tcpchannel.internal.NioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.NioTCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.NioTCPWriteRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPChannelFactory;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class NioTCPChannel
extends TCPChannel {
    private static WorkQueueManager workQueueManager = null;
    private static final TraceComponent tc = Tr.register(NioTCPChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    @Override
    public ChannelTermination setup(ChannelData runtimeConfig, TCPChannelConfiguration tcpConfig, TCPChannelFactory factory) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setup", (Object[])new Object[0]);
        }
        super.setup(runtimeConfig, tcpConfig, factory);
        if (workQueueManager == null) {
            workQueueManager = new WorkQueueManager();
        }
        if (!this.config.isInbound()) {
            this.connectionManager = new ConnectionManager(this, workQueueManager);
        }
        workQueueManager.startSelectors(this.config.isInbound());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setup");
        }
        return this.getWorkQueueManager();
    }

    protected WorkQueueManager getWorkQueueManager() {
        return workQueueManager;
    }

    @Override
    public SocketIOChannel createOutboundSocketIOChannel() throws IOException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        return NioSocketIOChannel.createIOChannel(socket, this);
    }

    @Override
    public SocketIOChannel createInboundSocketIOChannel(SocketChannel sc) {
        return NioSocketIOChannel.createIOChannel(sc.socket(), this);
    }

    @Override
    public TCPReadRequestContextImpl createReadInterface(TCPConnLink connLink) {
        return new NioTCPReadRequestContextImpl(connLink);
    }

    @Override
    public TCPWriteRequestContextImpl createWriteInterface(TCPConnLink connLink) {
        return new NioTCPWriteRequestContextImpl(connLink);
    }
}

