/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.NBAccept;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPPort;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

public class NBAcceptChannelSelector
extends ChannelSelector
implements FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(NBAcceptChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected int usageCount = 0;
    private long selectorTimeout = 0L;
    protected int numExceptions = 0;
    private long firstErrorTime = 0L;
    private int numAcceptIOExceptions = 0;
    private int numAcceptNulls = 0;
    private int numConfigureIOExceptions = 0;
    private int numCancelledKeys = 0;
    private boolean checkStartup = false;

    public NBAcceptChannelSelector(boolean argCheckStartup) throws IOException {
        super(false);
        this.checkStartup = argCheckStartup;
        this.selectorTimeout = TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Created Accept selector: " + this), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSelector() {
        Queue<Object> queue = this.getWorkQueue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("updateSelector - processing " + queue.size() + " items"), (Object[])new Object[0]);
        }
        NBAccept.EndPointActionInfo work = null;
        while (!queue.isEmpty()) {
            block17: {
                ServerSocket serverSocket;
                work = (NBAccept.EndPointActionInfo)queue.remove();
                if (work.action == 1) {
                    block16: {
                        try {
                            serverSocket = work.endPoint.getServerSocket();
                            serverSocket.getChannel().configureBlocking(false);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)("Registering: " + serverSocket), (Object[])new Object[0]);
                            }
                            serverSocket.getChannel().register(this.selector, 16, work.endPoint);
                            ++this.usageCount;
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".updateSelector"), (String)"101", (Object)this, (Object[])new Object[]{work});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block16;
                            Tr.event((Object)this, (TraceComponent)tc, (String)("Error registering port(" + work.endPoint.getListenPort() + "); " + t), (Object[])new Object[0]);
                        }
                    }
                    Object t = work.syncObject;
                    synchronized (t) {
                        work.syncObject.notify();
                        continue;
                    }
                }
                if (work.action != 0) continue;
                try {
                    serverSocket = work.endPoint.getServerSocket();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Removing: " + serverSocket), (Object[])new Object[0]);
                    }
                    serverSocket.getChannel().keyFor(this.selector).cancel();
                    this.selector.selectNow();
                    --this.usageCount;
                    if (this.usageCount <= 0) {
                        this.shutDown();
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".updateSelector"), (String)"102", (Object)this, (Object[])new Object[]{work});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block17;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Error removing port(" + work.endPoint.getListenPort() + "); " + t), (Object[])new Object[0]);
                }
            }
            Object object = work.syncObject;
            synchronized (object) {
                work.syncObject.notify();
            }
        }
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    @Override
    protected void channelSelectorClose() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void incrementExceptions() {
        long now = CHFWBundle.getApproxTime();
        if (now - this.firstErrorTime >= 600000L) {
            this.numExceptions = 1;
            this.firstErrorTime = now;
            this.numAcceptIOExceptions = 0;
            this.numAcceptNulls = 0;
            this.numCancelledKeys = 0;
            this.numConfigureIOExceptions = 0;
        } else {
            ++this.numExceptions;
        }
    }

    private void resetExceptions() {
        this.numExceptions = 0;
        this.firstErrorTime = 0L;
        this.numAcceptIOExceptions = 0;
        this.numAcceptNulls = 0;
        this.numCancelledKeys = 0;
        this.numConfigureIOExceptions = 0;
    }

    @Override
    protected boolean performRequest() {
        SocketChannel sc = null;
        boolean closeOnError = false;
        Set<SelectionKey> keySet = this.selector.selectedKeys();
        Iterator<SelectionKey> keyIterator = keySet.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("performRequest - processing " + keySet.size() + " items"), (Object[])new Object[0]);
        }
        while (keyIterator.hasNext()) {
            closeOnError = false;
            if (this.numExceptions >= 3100) {
                if (!this.pauseAccept()) continue;
                this.resetExceptions();
                continue;
            }
            if (this.numExceptions >= 200) {
                if (this.numExceptions == 1500) {
                    FFDCFilter.processException((Throwable)new Exception("TCP channel has received 1500 exceptions in a row on the accept selector"), (String)this.getClass().getName(), (String)"101", (Object)this);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            SelectionKey key = keyIterator.next();
            TCPPort endPoint = (TCPPort)key.attachment();
            TCPChannel tcpChannel = endPoint.getTCPChannel();
            try {
                block18: {
                    keyIterator.remove();
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                    try {
                        sc = serverSocketChannel.accept();
                        if (sc == null) break block18;
                        sc.configureBlocking(false);
                    }
                    catch (IOException ioe) {
                        this.incrementExceptions();
                        ++this.numAcceptIOExceptions;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                        Tr.event((Object)this, (TraceComponent)tc, (String)("TCP Channel: " + tcpChannel.getExternalName() + " caught IOException doing accept: " + ioe + " total=" + this.numExceptions + " count=" + this.numAcceptIOExceptions), (Object[])new Object[0]);
                        continue;
                    }
                }
                if (sc == null) {
                    this.incrementExceptions();
                    ++this.numAcceptNulls;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("TCP Channel: " + tcpChannel.getExternalName() + " accept() returned null, total=" + this.numExceptions + " count=" + this.numAcceptNulls), (Object[])new Object[0]);
                    continue;
                }
                Socket socket = sc.socket();
                if (!this.testSocket(sc)) continue;
                closeOnError = true;
                if (!tcpChannel.verifyConnection(socket)) {
                    this.closeSocketChannel(sc);
                    if (0 >= this.numExceptions) continue;
                    this.resetExceptions();
                    continue;
                }
                SocketIOChannel ioSocket = null;
                try {
                    ioSocket = tcpChannel.createInboundSocketIOChannel(sc);
                }
                catch (IOException ioe) {
                    this.incrementExceptions();
                    ++this.numConfigureIOExceptions;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("IOException caught while configuring socket: " + ioe + ", total=" + this.numExceptions + " count=" + this.numConfigureIOExceptions), (Object[])new Object[0]);
                    }
                    this.closeSocketChannel(sc);
                    continue;
                }
                endPoint.processNewConnection(ioSocket);
            }
            catch (CancelledKeyException cke) {
                this.incrementExceptions();
                ++this.numCancelledKeys;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Cancelled key exception found, cke=" + cke + " total=" + this.numExceptions + " count=" + this.numCancelledKeys), (Object[])new Object[0]);
                continue;
            }
            catch (Throwable t) {
                if (closeOnError) {
                    this.closeSocketChannel(sc);
                }
                throw new RuntimeException(t);
            }
            if (0 >= this.numExceptions) continue;
            this.resetExceptions();
        }
        return false;
    }

    private void closeSocketChannel(SocketChannel sc) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                try {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Closing connection, local: " + sc.socket().getLocalSocketAddress() + " remote: " + sc.socket().getRemoteSocketAddress()), (Object[])new Object[0]);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            try {
                sc.close();
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event((Object)this, (TraceComponent)tc, (String)("IOException caught while closing connection " + ioe), (Object[])new Object[0]);
            }
        }
    }

    private boolean testSocket(SocketChannel sc) {
        try {
            sc.socket().getLocalPort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("SocketChannel accepted, local: " + sc.socket().getLocalSocketAddress() + " remote: " + sc.socket().getRemoteSocketAddress()), (Object[])new Object[0]);
            }
        }
        catch (Throwable t) {
            block7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Closing invalid socket (getLocalPort failure)", (Object[])new Object[0]);
                }
                try {
                    sc.close();
                }
                catch (Throwable t2) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Error caught while closing connection " + t2), (Object[])new Object[0]);
                }
            }
            if (0 < this.numExceptions) {
                this.resetExceptions();
            }
            return false;
        }
        return true;
    }

    @Override
    protected void checkForTimeouts() {
        this.nextTimeoutTime = this.currentTime + this.selectorTimeout;
    }

    @Override
    void updateCount() {
    }

    @Override
    public String[] introspectSelf() {
        ArrayList<String> rc = new ArrayList<String>();
        rc.add(Thread.currentThread().getName());
        rc.add("selectorTimeout: " + this.selectorTimeout);
        rc.add("usageCount: " + this.usageCount);
        rc.add("quit: " + this.quit);
        rc.add("waitingToQuit: " + this.waitingToQuit);
        rc.add("firstErrorTime: " + this.firstErrorTime + "=" + new Date(this.firstErrorTime));
        rc.add("Total exceptions: " + this.numExceptions);
        rc.add("\tIOExceptions on accept: " + this.numAcceptIOExceptions);
        rc.add("\tnull sockets on accept: " + this.numAcceptNulls);
        rc.add("\tIOExceptions on configure: " + this.numConfigureIOExceptions);
        rc.add("\tnumber of cancelled keys: " + this.numCancelledKeys);
        rc.add("# of keys=" + this.selector.keys().size());
        try {
            for (SelectionKey key : this.selector.keys()) {
                rc.add("key: " + key.channel());
            }
        }
        catch (Throwable x) {
            rc.add("Exception Occurred Gathering Dump Data: " + x);
        }
        return rc.toArray(new String[rc.size()]);
    }
}

