/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ConnectionDescriptorImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.SimpleSync;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.channelfw.ConnectionDescriptor;
import com.ibm.wsspi.tcpchannel.TCPConfigConstants;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class ConnectionManager
implements TCPConfigConstants {
    private static final TraceComponent tc = Tr.register(ConnectionManager.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private WorkQueueManager workQueueMgr = null;
    private TCPChannel tcpChannel = null;

    public ConnectionManager(TCPChannel _tcpChannel, WorkQueueManager wqm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConnectionManager", (Object[])new Object[0]);
        }
        this.tcpChannel = _tcpChannel;
        this.workQueueMgr = wqm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConnectionManager");
        }
    }

    SocketIOChannel getConnection(TCPConnectRequestContext connectContext, TCPConnLink tcpConnLink, SimpleSync blocking) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getConnection for local: " + connectContext.getLocalAddress() + ", remote: " + connectContext.getRemoteAddress() + ", timeout: " + connectContext.getConnectTimeout()), (Object[])new Object[0]);
        }
        SocketIOChannel ioSocket = this.create(connectContext.getLocalAddress(), tcpConnLink);
        tcpConnLink.setSocketIOChannel(ioSocket);
        boolean isConnected = ioSocket.connect(connectContext.getRemoteAddress());
        if (isConnected) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"obtained connection without queuing to selector", (Object[])new Object[0]);
            }
            tcpConnLink.setCallCompleteLocal(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection");
            }
            return ioSocket;
        }
        ConnectInfo ci = new ConnectInfo(connectContext, tcpConnLink, ioSocket);
        ci.timeout = connectContext.getConnectTimeout();
        if (blocking != null) {
            ci.setSyncObject(blocking);
        }
        ci.setFinish();
        this.workQueueMgr.queueConnectForSelector(ci);
        if (blocking != null) {
            boolean connectDone = false;
            while (!connectDone) {
                blocking.simpleWait();
                connectDone = this.workQueueMgr.attemptConnectWork(ci);
            }
            if (ci.getAction() == 3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getConnection");
                }
                return ioSocket;
            }
            if (ci.getError() == null) {
                ci.setError(new IOException("Connection could not be established"));
            }
            throw ci.getError();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection");
        }
        return null;
    }

    private SocketIOChannel create(InetSocketAddress localAddress, TCPConnLink tcpConnLink) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create", (Object[])new Object[0]);
        }
        SocketIOChannel ioSocket = this.tcpChannel.createOutboundSocketIOChannel();
        Socket socket = ioSocket.getSocket();
        TCPChannelConfiguration tcpConfig = this.tcpChannel.getConfig();
        socket.setReuseAddress(tcpConfig.getSoReuseAddress());
        if (tcpConfig.getReceiveBufferSize() >= 4 && tcpConfig.getReceiveBufferSize() <= 0x1000000) {
            socket.setReceiveBufferSize(tcpConfig.getReceiveBufferSize());
        }
        if (tcpConfig.getSendBufferSize() >= 4 && tcpConfig.getSendBufferSize() <= 0x1000000) {
            socket.setSendBufferSize(tcpConfig.getSendBufferSize());
        }
        if (localAddress != null) {
            try {
                socket.bind(localAddress);
                InetAddress ia = localAddress.getAddress();
                if (ia != null) {
                    ConnectionDescriptor cd = tcpConnLink.getVirtualConnection().getConnectionDescriptor();
                    if (cd != null) {
                        cd.setAddrs(null, ia);
                    } else {
                        ConnectionDescriptorImpl cdi = new ConnectionDescriptorImpl(null, ia);
                        tcpConnLink.getVirtualConnection().setConnectionDescriptor(cdi);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("bound connection: " + tcpConnLink.getVirtualConnection().getConnectionDescriptor()), (Object[])new Object[0]);
                    }
                }
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bind error making outbound connection " + ioe), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"create", (Object)this);
                throw ioe;
            }
        }
        if (tcpConfig.getSoLinger() >= 0) {
            socket.setSoLinger(true, tcpConfig.getSoLinger());
        } else {
            socket.setSoLinger(false, 0);
        }
        socket.setKeepAlive(tcpConfig.getKeepAlive());
        socket.setTcpNoDelay(tcpConfig.getTcpNoDelay());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Socket created, local port: " + socket.getLocalPort()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create");
        }
        return ioSocket;
    }

    protected static class ConnectInfo {
        protected InetSocketAddress localAddress;
        protected InetSocketAddress remoteAddress;
        protected TCPConnLink tcpConnLink;
        protected SocketIOChannel ioSocket;
        protected SocketChannel channel;
        protected IOException errorException = null;
        protected SimpleSync syncObject = null;
        protected int timeout = -1;
        protected long nextTimeoutTime = 0L;
        protected static final int GET_CONNECTION = 0;
        protected static final int FINISH_CONNECTION = 1;
        protected static final int CALL_ERROR = 2;
        protected static final int FINISH_COMPLETE = 3;
        protected int action = 0;

        protected ConnectInfo(TCPConnectRequestContext connectContext, TCPConnLink cl, SocketIOChannel socket) {
            this.localAddress = connectContext.getLocalAddress();
            this.remoteAddress = connectContext.getRemoteAddress();
            this.tcpConnLink = cl;
            this.ioSocket = socket;
            this.channel = socket != null ? socket.getChannel() : null;
        }

        protected int getAction() {
            return this.action;
        }

        protected void setError(IOException e) {
            this.action = 2;
            this.errorException = e;
        }

        protected IOException getError() {
            return this.errorException;
        }

        protected void setFinish() {
            this.action = 1;
        }

        protected void setFinishComplete() {
            this.action = 3;
        }

        protected void setSyncObject(SimpleSync newSync) {
            this.syncObject = newSync;
        }

        protected SimpleSync getSyncObject() {
            return this.syncObject;
        }
    }
}

